/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib.domainobjects;

import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/services")
public interface DomainServiceResource {
    @GET
    @Path(value="/")
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/list\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response services();

    @DELETE
    @Path(value="/")
    public Response deleteServicesNotAllowed();

    @PUT
    @Path(value="/")
    public Response putServicesNotAllowed();

    @POST
    @Path(value="/")
    public Response postServicesNotAllowed();

    @GET
    @Path(value="/{serviceId}")
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/object\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/object\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response service(@PathParam(value="serviceId") String var1);

    @DELETE
    @Path(value="/{serviceId}")
    public Response deleteServiceNotAllowed(@PathParam(value="serviceId") String var1);

    @PUT
    @Path(value="/{serviceId}")
    public Response putServiceNotAllowed(@PathParam(value="serviceId") String var1);

    @POST
    @Path(value="/{serviceId}")
    public Response postServiceNotAllowed(@PathParam(value="serviceId") String var1);

    @GET
    @Path(value="/{serviceId}/actions/{actionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/object-action\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/object-action\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response actionPrompt(@PathParam(value="serviceId") String var1, @PathParam(value="actionId") String var2);

    @DELETE
    @Path(value="/{serviceId}/actions/{actionId}")
    public Response deleteActionPromptNotAllowed(@PathParam(value="serviceId") String var1, @PathParam(value="actionId") String var2);

    @PUT
    @Path(value="/{serviceId}/actions/{actionId}")
    public Response putActionPromptNotAllowed(@PathParam(value="serviceId") String var1, @PathParam(value="actionId") String var2);

    @POST
    @Path(value="/{serviceId}/actions/{actionId}")
    public Response postActionPromptNotAllowed(@PathParam(value="serviceId") String var1, @PathParam(value="actionId") String var2);

    @GET
    @Path(value="/{serviceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response invokeActionQueryOnly(@PathParam(value="serviceId") String var1, @PathParam(value="actionId") String var2, @QueryParam(value="x-isis-querystring") String var3);

    @PUT
    @Path(value="/{serviceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response invokeActionIdempotent(@PathParam(value="serviceId") String var1, @PathParam(value="actionId") String var2, InputStream var3);

    @POST
    @Path(value="/{serviceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response invokeAction(@PathParam(value="serviceId") String var1, @PathParam(value="actionId") String var2, InputStream var3);

    @DELETE
    @Path(value="/{serviceId}/actions/{actionId}/invoke")
    public Response deleteInvokeActionNotAllowed(@PathParam(value="serviceId") String var1, @PathParam(value="actionId") String var2);
}

