/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib.dtos;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.NonNull;

@JsonIgnoreProperties(value={"links", "extensions"})
public final class ScalarValueDtoV2 {
    private String type;
    private Object value;

    public static ScalarValueDtoV2 forNull(@NonNull Class<?> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return new ScalarValueDtoV2(type.getSimpleName(), null);
    }

    public static ScalarValueDtoV2 forValue(@NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new ScalarValueDtoV2(value.getClass().getSimpleName(), value);
    }

    @JsonIgnore
    public boolean isNull() {
        return this.value == null;
    }

    public String getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScalarValueDtoV2)) {
            return false;
        }
        ScalarValueDtoV2 other = (ScalarValueDtoV2)o;
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "ScalarValueDtoV2(type=" + this.getType() + ", value=" + this.getValue() + ")";
    }

    public ScalarValueDtoV2() {
    }

    private ScalarValueDtoV2(String type, Object value) {
        this.type = type;
        this.value = value;
    }
}

