/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;

public class JsonNodeUtils {
    private JsonNodeUtils() {
    }

    public static InputStream asInputStream(JsonNode jsonNode) {
        String jsonStr = jsonNode.toString();
        byte[] bytes = jsonStr.getBytes(StandardCharsets.UTF_8);
        return new ByteArrayInputStream(bytes);
    }

    public static InputStream asInputStream(JsonRepresentation jsonRepresentation) {
        String jsonStr = jsonRepresentation.toString();
        byte[] bytes = jsonStr.getBytes(StandardCharsets.UTF_8);
        return new ByteArrayInputStream(bytes);
    }

    public static ObjectNode walkNodeUpTo(ObjectNode node, List<String> keys) {
        for (String key : keys) {
            JsonNode jsonNode = node.get(key);
            if (jsonNode == null) {
                jsonNode = new ObjectNode(JsonNodeFactory.instance);
                node.set(key, jsonNode);
            } else if (!jsonNode.isObject()) {
                throw new IllegalArgumentException(String.format("walking path: '%s', existing key '%s' is not a map", keys, key));
            }
            node = (ObjectNode)jsonNode;
        }
        return node;
    }
}

