/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib.util;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;

public final class UrlEncodingUtils {
    public static final Function<String, String> FUNCTION = new Function<String, String>(){

        @Override
        public String apply(String input) {
            try {
                return URLDecoder.decode(input, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return "";
            }
        }
    };

    private UrlEncodingUtils() {
    }

    public static String urlDecode(String string) {
        return FUNCTION.apply(string);
    }

    public static List<String> urlDecode(List<String> values) {
        return _Lists.map(values, FUNCTION);
    }

    public static String[] urlDecode(String[] values) {
        List<String> asList = Arrays.asList(values);
        return UrlEncodingUtils.urlDecode(asList).toArray(new String[0]);
    }

    public static String urlEncode(JsonNode jsonNode) {
        return UrlEncodingUtils.urlEncode(jsonNode.toString());
    }

    public static String urlEncode(JsonRepresentation jsonRepresentation) {
        return UrlEncodingUtils.urlEncode(jsonRepresentation.toString());
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

