/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering;

import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.MediaType;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.iactn.InteractionProvider;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.viewer.restfulobjects.rendering.UrlDecoderUtils;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAdapterLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;

public interface IResourceContext {
    public String restfulUrlFor(String var1);

    public String applicationUrlFor(String var1);

    public List<MediaType> getAcceptableMediaTypes();

    public InteractionInitiatedBy getInteractionInitiatedBy();

    public Where getWhere();

    public ObjectAdapterLinkTo getObjectAdapterLinkTo();

    public List<List<String>> getFollowLinks();

    public boolean isValidateOnly();

    public boolean honorUiHints();

    public boolean objectPropertyValuesOnly();

    public boolean suppressDescribedByLinks();

    public boolean suppressUpdateLink();

    public boolean suppressMemberId();

    public boolean suppressMemberLinks();

    public boolean suppressMemberExtensions();

    public boolean suppressMemberDisabledReason();

    public boolean canEagerlyRender(ManagedObject var1);

    public RepresentationService.Intent getIntent();

    public InteractionProvider getInteractionProvider();

    public MetaModelContext getMetaModelContext();

    default public Optional<ManagedObject> getObjectAdapterForOidFromHref(String oidFromHref) {
        String oidStrUnencoded = UrlDecoderUtils.urlDecode(oidFromHref);
        return Bookmark.parse((String)oidStrUnencoded).flatMap(arg_0 -> ((MetaModelContext)this.getMetaModelContext()).loadObject(arg_0));
    }
}

