/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.ws.rs.core.MediaType;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.JsonValueEncoder;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.DomainTypeReprRenderer;

public abstract class ReprRendererAbstract<T>
implements ReprRenderer<T> {
    protected final IResourceContext resourceContext;
    protected final JsonValueEncoder jsonValueEncoder;
    private final LinkFollowSpecs linkFollower;
    private final RepresentationType representationType;
    protected final JsonRepresentation representation;
    private final Map<String, String> mediaTypeParams = _Maps.newLinkedHashMap();
    private final InteractionInitiatedBy interactionInitiatedBy;
    protected boolean includesSelf;

    public ReprRendererAbstract(IResourceContext resourceContext, LinkFollowSpecs linkFollower, RepresentationType representationType, JsonRepresentation representation) {
        this.resourceContext = resourceContext;
        this.jsonValueEncoder = (JsonValueEncoder)resourceContext.getMetaModelContext().getServiceRegistry().lookupServiceElseFail(JsonValueEncoder.class);
        this.linkFollower = this.asProvidedElseCreate(linkFollower);
        this.representationType = representationType;
        this.representation = representation;
        this.interactionInitiatedBy = ReprRendererAbstract.determineInteractionInitiatedByFrom(this.resourceContext);
    }

    private static InteractionInitiatedBy determineInteractionInitiatedByFrom(IResourceContext resourceContext) {
        return resourceContext.getInteractionInitiatedBy();
    }

    protected InteractionInitiatedBy getInteractionInitiatedBy() {
        return this.interactionInitiatedBy;
    }

    public LinkFollowSpecs getLinkFollowSpecs() {
        return this.linkFollower;
    }

    private LinkFollowSpecs asProvidedElseCreate(LinkFollowSpecs linkFollower) {
        if (linkFollower != null) {
            return linkFollower;
        }
        return LinkFollowSpecs.create(this.resourceContext.getFollowLinks());
    }

    @Override
    public MediaType getMediaType() {
        return this.representationType.getJsonMediaType(this.mediaTypeParams);
    }

    protected void addMediaTypeParams(String param, String paramValue) {
        this.mediaTypeParams.put(param, paramValue);
    }

    public <R extends ReprRendererAbstract<T>> R includesSelf() {
        this.includesSelf = true;
        return (R)((ReprRendererAbstract)_Casts.uncheckedCast((Object)this));
    }

    public <R extends ReprRendererAbstract<T>> R withLink(Rel rel, String href) {
        if (href != null) {
            this.getLinks().arrayAdd(LinkBuilder.newBuilder(this.resourceContext, rel.getName(), this.representationType, href, new Object[0]).build());
        }
        return (R)((ReprRendererAbstract)_Casts.uncheckedCast((Object)this));
    }

    public <R extends ReprRendererAbstract<T>> R withLink(Rel rel, JsonRepresentation link) {
        String relStr = link.getString("rel");
        if (relStr == null || !relStr.equals(rel.getName())) {
            throw new IllegalArgumentException("Provided link does not have a 'rel' of '" + rel.getName() + "'; was: " + link);
        }
        if (link != null) {
            this.getLinks().arrayAdd(link);
        }
        return (R)((ReprRendererAbstract)_Casts.uncheckedCast((Object)this));
    }

    protected JsonRepresentation getLinks() {
        JsonRepresentation links = this.representation.getArray("links");
        if (links == null) {
            links = JsonRepresentation.newArray();
            this.representation.mapPut("links", links);
        }
        return links;
    }

    protected void addLink(Rel rel, ObjectSpecification objectSpec) {
        if (objectSpec == null) {
            return;
        }
        LinkBuilder linkBuilder = DomainTypeReprRenderer.newLinkToBuilder(this.getResourceContext(), rel, objectSpec);
        JsonRepresentation link = linkBuilder.build();
        this.getLinks().arrayAdd(link);
        LinkFollowSpecs linkFollower = this.getLinkFollowSpecs().follow("links", new Object[0]);
        if (linkFollower.matches(link)) {
            DomainTypeReprRenderer renderer = new DomainTypeReprRenderer(this.getResourceContext(), linkFollower, JsonRepresentation.newMap((String[])new String[0])).with(objectSpec);
            link.mapPut("value", renderer.render());
        }
    }

    protected JsonRepresentation getExtensions() {
        JsonRepresentation extensions = this.representation.getMap("extensions");
        if (extensions == null) {
            extensions = JsonRepresentation.newMap((String[])new String[0]);
            this.representation.mapPut("extensions", extensions);
        }
        return extensions;
    }

    public ReprRendererAbstract<T> withExtensions(JsonRepresentation extensions) {
        if (!extensions.isMap()) {
            throw new IllegalArgumentException("extensions must be a map");
        }
        this.representation.mapPut("extensions", extensions);
        return this;
    }

    @Override
    public abstract JsonRepresentation render();

    protected final void addExtensionsIsisProprietaryChangedObjects() {
        ArrayList changedObjects = _Lists.newArrayList();
        ArrayList disposedObjects = _Lists.newArrayList();
        this.addToExtensions("changed", changedObjects);
        this.addToExtensions("disposed", disposedObjects);
    }

    private void addToExtensions(String key, List<ManagedObject> adapters) {
        if (adapters == null || adapters.isEmpty()) {
            return;
        }
        JsonRepresentation adapterList = JsonRepresentation.newArray();
        this.getExtensions().mapPut(key, adapterList);
        for (ManagedObject adapter : adapters) {
            adapterList.arrayAdd(DomainObjectReprRenderer.newLinkToBuilder(this.getResourceContext(), Rel.VALUE, adapter).build());
        }
    }

    protected Stream<ManagedObject> streamServiceAdapters() {
        MetaModelContext metaModelContext = this.resourceContext.getMetaModelContext();
        return metaModelContext.streamServiceAdapters();
    }

    public IResourceContext getResourceContext() {
        return this.resourceContext;
    }

    public JsonValueEncoder getJsonValueEncoder() {
        return this.jsonValueEncoder;
    }
}

