/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.facets.object.domainservicelayout.DomainServiceLayoutFacet;
import org.apache.isis.core.metamodel.interactions.managed.ManagedAction;
import org.apache.isis.core.metamodel.interactions.managed.ManagedCollection;
import org.apache.isis.core.metamodel.interactions.managed.ManagedMember;
import org.apache.isis.core.metamodel.interactions.managed.ManagedProperty;
import org.apache.isis.core.metamodel.services.ServiceUtil;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ManagedObjects;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.MixedIn;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.RestfulHttpMethod;
import org.apache.isis.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRendererAbstract;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.JsonValueEncoder;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectActionReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAdapterLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectCollectionReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectPropertyReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.DomainTypeReprRenderer;

public class DomainObjectReprRenderer
extends ReprRendererAbstract<ManagedObject> {
    private static final String X_RO_DOMAIN_TYPE = "x-ro-domain-type";
    private ObjectAdapterLinkTo linkToBuilder;
    private ManagedObject objectAdapter;
    private Mode mode = Mode.REGULAR;

    public static LinkBuilder newLinkToBuilder(IResourceContext resourceContext, Rel rel, ManagedObject objectAdapter) {
        String objectRef = ManagedObjects.stringifyElseFail((ManagedObject)objectAdapter, (String)"/");
        String url = "objects/" + objectRef;
        return LinkBuilder.newBuilder(resourceContext, rel.getName(), RepresentationType.DOMAIN_OBJECT, url, new Object[0]).withTitle(objectAdapter.titleString());
    }

    public static LinkBuilder newLinkToObjectLayoutBuilder(IResourceContext resourceContext, ManagedObject objectAdapter) {
        Rel rel = Rel.OBJECT_LAYOUT;
        String objectRef = ManagedObjects.stringifyElseFail((ManagedObject)objectAdapter, (String)"/");
        String url = "objects/" + objectRef + "/object-layout";
        return LinkBuilder.newBuilder(resourceContext, rel.getName(), RepresentationType.OBJECT_LAYOUT, url, new Object[0]);
    }

    public static LinkBuilder newLinkToObjectIconBuilder(IResourceContext resourceContext, ManagedObject objectAdapter) {
        Rel rel = Rel.OBJECT_ICON;
        String objectRef = ManagedObjects.stringifyElseFail((ManagedObject)objectAdapter, (String)"/");
        String url = "objects/" + objectRef + "/object-icon";
        return LinkBuilder.newBuilder(resourceContext, rel.getName(), RepresentationType.IMAGE, url, new Object[0]);
    }

    public DomainObjectReprRenderer(IResourceContext resourceContext, LinkFollowSpecs linkFollower, JsonRepresentation representation) {
        super(resourceContext, linkFollower, RepresentationType.DOMAIN_OBJECT, representation);
        this.usingLinkToBuilder(new DomainObjectLinkTo());
    }

    public DomainObjectReprRenderer usingLinkToBuilder(ObjectAdapterLinkTo objectAdapterLinkToBuilder) {
        this.linkToBuilder = objectAdapterLinkToBuilder.usingUrlBase(this.resourceContext);
        return this;
    }

    public DomainObjectReprRenderer with(ManagedObject objectAdapter) {
        this.objectAdapter = objectAdapter;
        String domainTypeHref = DomainTypeReprRenderer.newLinkToBuilder(this.getResourceContext(), Rel.DOMAIN_TYPE, objectAdapter.getSpecification()).build().getString("href");
        this.addMediaTypeParams(X_RO_DOMAIN_TYPE, domainTypeHref);
        return this;
    }

    @Override
    public JsonRepresentation render() {
        if (this.representation == null) {
            return null;
        }
        boolean isService = this.objectAdapter.getSpecification().isManagedBean();
        if (!this.mode.isArgs()) {
            Optional oidIfAny = this.objectAdapter.getBookmark();
            if (ManagedObjects.isIdentifiable((ManagedObject)this.objectAdapter)) {
                if (this.includesSelf) {
                    this.addLinkToSelf();
                }
                oidIfAny.ifPresent(oid -> {
                    String oidStr = oid.stringify();
                    this.getExtensions().mapPut("oid", oidStr);
                });
            }
            String title = this.objectAdapter.titleString();
            this.representation.mapPut("title", title);
            if (isService) {
                this.representation.mapPut("serviceId", ServiceUtil.idOfAdapter((ManagedObject)this.objectAdapter));
            } else {
                oidIfAny.ifPresent(oid -> {
                    Optional.ofNullable(oid.getLogicalTypeName()).ifPresent(domainType -> this.representation.mapPut("domainType", domainType));
                    this.representation.mapPut("instanceId", oid.getIdentifier());
                });
            }
        }
        if (!this.mode.isUpdatePropertiesLinkArgs()) {
            this.withMembers(this.objectAdapter);
        }
        if (this.mode.includeDescribedBy() && !this.resourceContext.suppressDescribedByLinks()) {
            this.addLinkToDescribedBy();
            this.addLinkToObjectLayout();
            this.addLinkToObjectIcon();
        }
        if (isService && this.mode.includeUp()) {
            this.addLinkToUp();
        }
        if (!this.mode.isArgs() && !this.resourceContext.objectPropertyValuesOnly()) {
            DomainServiceLayout.MenuBar menuBar;
            ObjectSpecification objectSpec;
            DomainServiceLayoutFacet layoutFacet;
            this.addPersistLinkIfTransientAndPersistable();
            this.addUpdatePropertiesLinkIfRequired();
            this.getExtensions().mapPut("isService", isService);
            this.getExtensions().mapPut("isPersistent", ManagedObjects.isIdentifiable((ManagedObject)this.objectAdapter));
            if (isService && (layoutFacet = (DomainServiceLayoutFacet)(objectSpec = this.objectAdapter.getSpecification()).getFacet(DomainServiceLayoutFacet.class)) != null && (menuBar = layoutFacet.getMenuBar()) != null) {
                this.getExtensions().mapPut("menuBar", (Object)menuBar);
            }
        }
        return this.representation;
    }

    private void addLinkToSelf() {
        JsonRepresentation link = this.linkToBuilder.with(this.objectAdapter).builder(Rel.SELF).build();
        LinkFollowSpecs linkFollower = this.getLinkFollowSpecs().follow("links", new Object[0]);
        if (linkFollower.matches(link)) {
            DomainObjectReprRenderer renderer = new DomainObjectReprRenderer(this.getResourceContext(), linkFollower, JsonRepresentation.newMap((String[])new String[0]));
            renderer.with(this.objectAdapter);
            link.mapPut("value", renderer.render());
        }
        this.getLinks().arrayAdd(link);
    }

    private void addLinkToDescribedBy() {
        JsonRepresentation link = DomainTypeReprRenderer.newLinkToBuilder(this.getResourceContext(), Rel.DESCRIBEDBY, this.objectAdapter.getSpecification()).build();
        LinkFollowSpecs linkFollower = this.getLinkFollowSpecs().follow("links", new Object[0]);
        if (linkFollower.matches(link)) {
            DomainTypeReprRenderer renderer = new DomainTypeReprRenderer(this.getResourceContext(), linkFollower, JsonRepresentation.newMap((String[])new String[0]));
            renderer.with(this.objectAdapter.getSpecification());
            link.mapPut("value", renderer.render());
        }
        this.getLinks().arrayAdd(link);
    }

    private void addLinkToObjectLayout() {
        LinkBuilder linkBuilder = DomainObjectReprRenderer.newLinkToObjectLayoutBuilder(this.getResourceContext(), this.objectAdapter);
        JsonRepresentation link = linkBuilder.build();
        this.getLinks().arrayAdd(link);
    }

    private void addLinkToObjectIcon() {
        LinkBuilder linkBuilder = DomainObjectReprRenderer.newLinkToObjectIconBuilder(this.getResourceContext(), this.objectAdapter);
        JsonRepresentation link = linkBuilder.build();
        this.getLinks().arrayAdd(link);
    }

    private void addLinkToUp() {
        JsonRepresentation link = LinkBuilder.newBuilder(this.resourceContext, Rel.UP.getName(), RepresentationType.LIST, "services", new Object[0]).build();
        this.getLinks().arrayAdd(link);
    }

    private DomainObjectReprRenderer withMembers(ManagedObject objectAdapter) {
        JsonRepresentation appendTo = this.mode.isUpdatePropertiesLinkArgs() ? this.representation : JsonRepresentation.newMap((String[])new String[0]);
        List<ObjectAssociation> associations = objectAdapter.getSpecification().streamAssociations(MixedIn.INCLUDED).collect(Collectors.toList());
        this.addProperties(objectAdapter, appendTo, associations);
        if (!this.resourceContext.objectPropertyValuesOnly()) {
            if (!this.mode.isArgs()) {
                this.addCollections(objectAdapter, appendTo, associations);
            }
            if (this.mode.isRegular()) {
                Stream actions = objectAdapter.getSpecification().streamAnyActions(MixedIn.INCLUDED);
                this.addActions(objectAdapter, actions, appendTo);
            }
        }
        if (!this.mode.isUpdatePropertiesLinkArgs()) {
            this.representation.mapPut("members", appendTo);
        }
        return this;
    }

    private void addProperties(ManagedObject objectAdapter, JsonRepresentation members, List<ObjectAssociation> associations) {
        for (ObjectAssociation assoc : associations) {
            Consent visibility;
            if (this.mode.checkVisibility() && !(visibility = assoc.isVisible(objectAdapter, this.getInteractionInitiatedBy(), this.resourceContext.getWhere())).isAllowed() || !(assoc instanceof OneToOneAssociation)) continue;
            OneToOneAssociation property = (OneToOneAssociation)assoc;
            LinkFollowSpecs linkFollowerForProp = this.getLinkFollowSpecs().follow("members[" + property.getId() + "]", new Object[0]);
            JsonRepresentation propertyRepresentation = JsonRepresentation.newMap((String[])new String[0]);
            ObjectPropertyReprRenderer renderer = new ObjectPropertyReprRenderer(this.getResourceContext(), linkFollowerForProp, property.getId(), propertyRepresentation);
            renderer.with((ManagedMember)ManagedProperty.of((ManagedObject)objectAdapter, (OneToOneAssociation)property, (Where)this.resourceContext.getWhere())).usingLinkTo(this.linkToBuilder);
            if (this.mode.isArgs()) {
                renderer.asArguments();
            }
            if (this.mode.isEventSerialization()) {
                renderer.asEventSerialization();
            }
            JsonRepresentation propertyValueRepresentation = renderer.render();
            JsonRepresentation propertyRepr = this.resourceContext.objectPropertyValuesOnly() ? propertyValueRepresentation.getRepresentation("value", new Object[0]) : propertyValueRepresentation;
            members.mapPut(assoc.getId(), propertyRepr);
        }
    }

    private void addCollections(ManagedObject objectAdapter, JsonRepresentation members, List<ObjectAssociation> associations) {
        for (ObjectAssociation assoc : associations) {
            Consent visibility;
            if (this.mode.checkVisibility() && !(visibility = assoc.isVisible(objectAdapter, this.getInteractionInitiatedBy(), this.resourceContext.getWhere())).isAllowed() || !(assoc instanceof OneToManyAssociation)) continue;
            OneToManyAssociation collection = (OneToManyAssociation)assoc;
            LinkFollowSpecs linkFollowerForColl = this.getLinkFollowSpecs().follow("members[" + collection.getId() + "]", new Object[0]);
            JsonRepresentation collectionRepresentation = JsonRepresentation.newMap((String[])new String[0]);
            ObjectCollectionReprRenderer renderer = new ObjectCollectionReprRenderer(this.getResourceContext(), linkFollowerForColl, collection.getId(), collectionRepresentation);
            Where where = this.resourceContext.getWhere();
            renderer.with((ManagedMember)ManagedCollection.of((ManagedObject)objectAdapter, (OneToManyAssociation)collection, (Where)where)).usingLinkTo(this.linkToBuilder);
            if (this.mode.isEventSerialization()) {
                renderer.asEventSerialization();
            }
            members.mapPut(assoc.getId(), renderer.render());
        }
    }

    private void addActions(ManagedObject objectAdapter, Stream<ObjectAction> actions, JsonRepresentation members) {
        actions.filter(action -> {
            Consent visibility = action.isVisible(objectAdapter, this.getInteractionInitiatedBy(), this.resourceContext.getWhere());
            return visibility.isAllowed();
        }).forEach(action -> {
            LinkFollowSpecs linkFollowSpecs = this.getLinkFollowSpecs().follow("members[" + action.getId() + "]", new Object[0]);
            ObjectActionReprRenderer renderer = new ObjectActionReprRenderer(this.getResourceContext(), linkFollowSpecs, action.getId(), JsonRepresentation.newMap((String[])new String[0]));
            Where where = this.resourceContext.getWhere();
            renderer.with((ManagedMember)ManagedAction.of((ManagedObject)objectAdapter, (ObjectAction)action, (Where)where)).usingLinkTo(this.linkToBuilder);
            members.mapPut(action.getId(), renderer.render());
        });
    }

    private void addPersistLinkIfTransientAndPersistable() {
        if (ManagedObjects.isIdentifiable((ManagedObject)this.objectAdapter)) {
            return;
        }
        DomainObjectReprRenderer renderer = new DomainObjectReprRenderer(this.getResourceContext(), null, JsonRepresentation.newMap((String[])new String[0]));
        JsonRepresentation domainObjectRepr = renderer.with(this.objectAdapter).asPersistLinkArguments().render();
        String domainType = this.objectAdapter.getSpecification().getLogicalTypeName();
        LinkBuilder persistLinkBuilder = LinkBuilder.newBuilder(this.getResourceContext(), Rel.PERSIST.getName(), RepresentationType.DOMAIN_OBJECT, "objects/%s", domainType).withHttpMethod(RestfulHttpMethod.POST).withArguments(domainObjectRepr);
        this.getLinks().arrayAdd(persistLinkBuilder.build());
    }

    private DomainObjectReprRenderer asPersistLinkArguments() {
        this.mode = Mode.PERSIST_LINK_ARGUMENTS;
        return this;
    }

    private DomainObjectReprRenderer asUpdatePropertiesLinkArguments() {
        this.mode = Mode.UPDATE_PROPERTIES_LINK_ARGUMENTS;
        return this;
    }

    public DomainObjectReprRenderer asEventSerialization() {
        this.mode = Mode.EVENT_SERIALIZATION;
        return this;
    }

    private void addUpdatePropertiesLinkIfRequired() {
        if (this.mode.isEventSerialization()) {
            return;
        }
        if (!ManagedObjects.isIdentifiable((ManagedObject)this.objectAdapter)) {
            return;
        }
        boolean isService = this.objectAdapter.getSpecification().isManagedBean();
        if (isService) {
            return;
        }
        DomainObjectReprRenderer renderer = new DomainObjectReprRenderer(this.getResourceContext(), null, JsonRepresentation.newMap((String[])new String[0]));
        JsonRepresentation domainObjectRepr = renderer.with(this.objectAdapter).asUpdatePropertiesLinkArguments().render();
        if (!this.getResourceContext().suppressUpdateLink()) {
            String objectRef = ManagedObjects.stringifyElseFail((ManagedObject)this.objectAdapter);
            LinkBuilder updateLinkBuilder = LinkBuilder.newBuilder(this.getResourceContext(), Rel.UPDATE.getName(), RepresentationType.DOMAIN_OBJECT, "objects/%s", objectRef).withHttpMethod(RestfulHttpMethod.PUT).withArguments(domainObjectRepr);
            this.getLinks().arrayAdd(updateLinkBuilder.build());
        }
    }

    public static Object valueOrRef(IResourceContext context, JsonValueEncoder jsonValueEncoder, ManagedObject domainObject) {
        ObjectSpecification spec = domainObject.getSpecification();
        if (spec.isValue()) {
            String format = null;
            return jsonValueEncoder.asObject(domainObject, format);
        }
        return DomainObjectReprRenderer.newLinkToBuilder(context, Rel.VALUE, domainObject).withTitle(domainObject.getTitle()).build();
    }

    private static enum Mode {
        REGULAR,
        PERSIST_LINK_ARGUMENTS,
        UPDATE_PROPERTIES_LINK_ARGUMENTS,
        EVENT_SERIALIZATION;


        public boolean isRegular() {
            return this == REGULAR;
        }

        public boolean isPersistLinkArgs() {
            return this == PERSIST_LINK_ARGUMENTS;
        }

        public boolean isUpdatePropertiesLinkArgs() {
            return this == UPDATE_PROPERTIES_LINK_ARGUMENTS;
        }

        public boolean isEventSerialization() {
            return this == EVENT_SERIALIZATION;
        }

        public boolean includeDescribedBy() {
            return this.isRegular() || this.isPersistLinkArgs();
        }

        public boolean includeUp() {
            return this.isRegular();
        }

        public boolean checkVisibility() {
            return this.isRegular() || this.isUpdatePropertiesLinkArgs();
        }

        public boolean isArgs() {
            return this.isPersistLinkArgs() || this.isUpdatePropertiesLinkArgs();
        }
    }
}

