/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import com.fasterxml.jackson.databind.node.NullNode;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.NonNull;
import org.apache.isis.applib.exceptions.recoverable.TextEntryParseException;
import org.apache.isis.applib.value.semantics.ValueDecomposition;
import org.apache.isis.applib.value.semantics.ValueSemanticsProvider;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.facets.object.value.ValueSerializer;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ManagedObjects;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.JsonValueEncoder_Converters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.viewer.ro.JsonValueEncoder")
@Priority(value=0x1FFFFFFF)
@Qualifier(value="Default")
public class JsonValueEncoder {
    private static final Logger log = LogManager.getLogger(JsonValueEncoder.class);
    @Inject
    private SpecificationLoader specificationLoader;
    private Map<Class<?>, JsonValueConverter> converterByClass = _Maps.newLinkedHashMap();

    @PostConstruct
    public void init() {
        Function<Object, ManagedObject> pojoToAdapter = pojo -> ManagedObject.lazy((SpecificationLoader)this.specificationLoader, (Object)pojo);
        new JsonValueEncoder_Converters().asList(pojoToAdapter).forEach(this::registerConverter);
    }

    private void registerConverter(JsonValueConverter jvc) {
        jvc.getClasses().forEach(cls -> this.converterByClass.put((Class<?>)cls, jvc));
    }

    public ManagedObject asAdapter(ObjectSpecification objectSpec, JsonRepresentation argValueRepr, String format) {
        if (argValueRepr == null) {
            return null;
        }
        if (objectSpec == null) {
            throw new IllegalArgumentException("ObjectSpecification is required");
        }
        if (!argValueRepr.isValue()) {
            throw new IllegalArgumentException("Representation must be of a value");
        }
        ValueFacet valueFacet = (ValueFacet)objectSpec.getFacet(ValueFacet.class);
        if (valueFacet == null) {
            String reason = "ObjectSpec expected to have a ValueFacet";
            throw new IllegalArgumentException(reason);
        }
        Class cls = objectSpec.getCorrespondingClass();
        JsonValueConverter jvc = this.converterByClass.get(cls);
        if (jvc == null) {
            if (argValueRepr.isString()) {
                String argStr = argValueRepr.asString();
                return ManagedObject.of((ObjectSpecification)objectSpec, (Object)valueFacet.fromEncodedString(ValueSerializer.Format.JSON, argStr));
            }
            throw new IllegalArgumentException("Unable to parse value");
        }
        ManagedObject asAdapter = jvc.asAdapter(argValueRepr, format);
        if (asAdapter != null) {
            return asAdapter;
        }
        if (argValueRepr.isString()) {
            String argStr = argValueRepr.asString();
            try {
                return ManagedObject.of((ObjectSpecification)objectSpec, (Object)valueFacet.fromEncodedString(ValueSerializer.Format.JSON, argStr));
            }
            catch (TextEntryParseException ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
        }
        throw new IllegalArgumentException("Could not parse value '" + argValueRepr.asString() + "' as a " + objectSpec.getFullIdentifier());
    }

    public Object appendValueAndFormat(ManagedObject objectAdapter, ObjectSpecification objectSpecification, JsonRepresentation repr, String format, boolean suppressExtensions) {
        Class cls = objectSpecification.getCorrespondingClass();
        JsonValueConverter jsonValueConverter = this.converterByClass.get(cls);
        if (jsonValueConverter != null) {
            return jsonValueConverter.appendValueAndFormat(objectAdapter, format, repr, suppressExtensions);
        }
        NullNode value = ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)objectAdapter) ? NullNode.getInstance() : JsonValueEncoder.decomposeToJson(objectSpecification, objectAdapter.getPojo()).map(Object.class::cast).orElseGet(() -> {
            log.warn("{Could not resolve a ValueComposer for {}, falling back to rendering as 'null'. Make sure the framework has access to a ValueSemanticsProvider<{}> that implements ValueComposer<{}>}", (Object)objectSpecification.getLogicalTypeName(), (Object)objectSpecification.getCorrespondingClass().getSimpleName(), (Object)objectSpecification.getCorrespondingClass().getSimpleName());
            return NullNode.getInstance();
        });
        repr.mapPut("value", (Object)value);
        JsonValueEncoder.appendFormats(repr, "string", "string", suppressExtensions);
        return value;
    }

    private static <T> Optional<ValueDecomposition> decompose(ObjectSpecification spec, T pojo) {
        return spec.lookupFacet(ValueFacet.class).flatMap(ValueFacet::selectDefaultSemantics).map(composer -> ((ValueSemanticsProvider)composer).decompose(pojo));
    }

    private static <T> Optional<String> decomposeToJson(ObjectSpecification spec, T pojo) {
        return JsonValueEncoder.decompose(spec, pojo).map(ValueDecomposition::toJson);
    }

    @Nullable
    public Object asObject(@NonNull ManagedObject adapter, String format) {
        if (adapter == null) {
            throw new NullPointerException("adapter is marked non-null but is null");
        }
        ObjectSpecification objectSpec = adapter.getSpecification();
        Class cls = objectSpec.getCorrespondingClass();
        JsonValueConverter jsonValueConverter = this.converterByClass.get(cls);
        if (jsonValueConverter != null) {
            return jsonValueConverter.asObject(adapter, format);
        }
        ValueFacet valueFacet = (ValueFacet)objectSpec.getFacet(ValueFacet.class);
        if (valueFacet == null) {
            throw new IllegalArgumentException("objectSpec expected to have ValueFacet");
        }
        return valueFacet.toEncodedString(ValueSerializer.Format.JSON, adapter.getPojo());
    }

    static void appendFormats(JsonRepresentation repr, String format, String xIsisFormat, boolean suppressExtensions) {
        if (format != null) {
            repr.mapPut("format", format);
        }
        if (!suppressExtensions && xIsisFormat != null) {
            repr.mapPut("extensions.x-isis-format", xIsisFormat);
        }
    }

    static Object unwrapAsObjectElseNullNode(ManagedObject adapter) {
        return adapter != null ? adapter.getPojo() : NullNode.getInstance();
    }

    public static JsonValueEncoder forTesting(SpecificationLoader specificationLoader) {
        JsonValueEncoder jsonValueEncoder = new JsonValueEncoder();
        jsonValueEncoder.specificationLoader = specificationLoader;
        jsonValueEncoder.init();
        return jsonValueEncoder;
    }

    public static abstract class JsonValueConverter {
        protected final String format;
        protected final String xIsisFormat;
        private final Can<Class<?>> classes;

        public JsonValueConverter(String format, String xIsisFormat, Class<?> ... classes) {
            this.format = format;
            this.xIsisFormat = xIsisFormat;
            this.classes = Can.ofArray((Object[])classes);
        }

        public abstract ManagedObject asAdapter(JsonRepresentation var1, String var2);

        public Object appendValueAndFormat(ManagedObject objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
            Object value = JsonValueEncoder.unwrapAsObjectElseNullNode(objectAdapter);
            repr.mapPut("value", value);
            JsonValueEncoder.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
            return value;
        }

        public Object asObject(ManagedObject objectAdapter, String format) {
            return objectAdapter.getPojo();
        }

        public Can<Class<?>> getClasses() {
            return this.classes;
        }
    }

    public static class ExpectedStringRepresentingValueException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
    }
}

