/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.facets.collections.CollectionFacet;
import org.apache.isis.core.metamodel.facets.collections.collection.defaultview.DefaultViewFacet;
import org.apache.isis.core.metamodel.interactions.managed.ManagedCollection;
import org.apache.isis.core.metamodel.interactions.managed.ManagedMember;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ManagedObjects;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.AbstractObjectMemberReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.CollectionSemantics;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.CollectionDescriptionReprRenderer;

public class ObjectCollectionReprRenderer
extends AbstractObjectMemberReprRenderer<OneToManyAssociation> {
    public ObjectCollectionReprRenderer(IResourceContext resourceContext, LinkFollowSpecs linkFollowSpecs, String collectionId, JsonRepresentation representation) {
        super(resourceContext, linkFollowSpecs, collectionId, RepresentationType.OBJECT_COLLECTION, representation, Where.PARENTED_TABLES);
    }

    @Override
    public JsonRepresentation render() {
        boolean eagerlyRender;
        if (this.representation == null) {
            return null;
        }
        this.renderMemberContent();
        LinkFollowSpecs followValue = this.getLinkFollowSpecs().follow("value", new Object[0]);
        boolean bl = eagerlyRender = this.resourceContext.honorUiHints() && this.renderEagerly() || !followValue.isTerminated();
        if (this.mode.isInline() && eagerlyRender || this.mode.isStandalone() || this.mode.isMutated() || this.mode.isEventSerialization() || !ManagedObjects.isIdentifiable((ManagedObject)this.objectAdapter)) {
            this.addValue(followValue);
        }
        if (!this.mode.isEventSerialization()) {
            this.putDisabledReasonIfDisabled();
        }
        if (this.mode.isStandalone() || this.mode.isMutated()) {
            this.addExtensionsIsisProprietaryChangedObjects();
        }
        return this.representation;
    }

    private boolean renderEagerly() {
        DefaultViewFacet defaultViewFacet = (DefaultViewFacet)((OneToManyAssociation)this.objectMember).getFacet(DefaultViewFacet.class);
        return defaultViewFacet != null && Objects.equals(defaultViewFacet.value(), "table");
    }

    private void addValue(LinkFollowSpecs linkFollower) {
        ManagedObject valueAdapter = ((OneToManyAssociation)this.objectMember).get(this.objectAdapter, this.getInteractionInitiatedBy());
        if (valueAdapter == null) {
            return;
        }
        LinkFollowSpecs followHref = linkFollower.follow("href", new Object[0]);
        boolean eagerlyRender = this.resourceContext.honorUiHints() && this.renderEagerly(valueAdapter) || !followHref.isTerminated();
        ArrayList list = _Lists.newArrayList();
        CollectionFacet.streamAdapters((ManagedObject)valueAdapter).forEach(elementAdapter -> {
            LinkBuilder valueLinkBuilder = DomainObjectReprRenderer.newLinkToBuilder(this.resourceContext, Rel.VALUE, elementAdapter);
            if (eagerlyRender) {
                DomainObjectReprRenderer domainObjectReprRenderer = new DomainObjectReprRenderer(this.getResourceContext(), followHref, JsonRepresentation.newMap((String[])new String[0])).with((ManagedObject)elementAdapter);
                if (this.mode.isEventSerialization()) {
                    domainObjectReprRenderer.asEventSerialization();
                }
                valueLinkBuilder.withValue(domainObjectReprRenderer.render());
            }
            list.add(valueLinkBuilder.build());
        });
        this.representation.mapPut("value", (Object)list);
    }

    private boolean renderEagerly(ManagedObject valueAdapter) {
        return this.renderEagerly() && this.resourceContext.canEagerlyRender(valueAdapter);
    }

    @Override
    protected void followDetailsLink(JsonRepresentation detailsLink) {
        Where where = this.resourceContext.getWhere();
        JsonRepresentation jsonRepresentation = JsonRepresentation.newMap((String[])new String[0]);
        AbstractObjectMemberReprRenderer objectCollectionReprRenderer = new ObjectCollectionReprRenderer(this.getResourceContext(), this.getLinkFollowSpecs(), null, jsonRepresentation).with((ManagedMember)ManagedCollection.of((ManagedObject)this.objectAdapter, (OneToManyAssociation)((OneToManyAssociation)this.objectMember), (Where)where)).asFollowed();
        detailsLink.mapPut("value", objectCollectionReprRenderer.render());
    }

    @Override
    protected void addMutatorLinksIfEnabled() {
    }

    @Override
    protected void addLinksToFormalDomainModel() {
        if (this.resourceContext.suppressDescribedByLinks()) {
            return;
        }
        JsonRepresentation link = CollectionDescriptionReprRenderer.newLinkToBuilder(this.resourceContext, Rel.DESCRIBEDBY, this.objectAdapter.getSpecification(), (OneToManyAssociation)this.objectMember).build();
        this.getLinks().arrayAdd(link);
    }

    @Override
    protected void putExtensionsIsisProprietary() {
        CollectionSemantics semantics = CollectionSemantics.determine((OneToManyAssociation)this.objectMember);
        this.getExtensions().mapPut("collectionSemantics", semantics.name().toLowerCase());
    }
}

