/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domaintypes;

import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectFeature;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRendererAbstract;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.ParentSpecAndFeature;

public abstract class AbstractTypeFeatureReprRenderer<T extends ObjectFeature>
extends ReprRendererAbstract<ParentSpecAndFeature<T>> {
    protected ObjectSpecification objectSpecification;
    protected T objectFeature;

    public AbstractTypeFeatureReprRenderer(IResourceContext resourceContext, LinkFollowSpecs linkFollower, RepresentationType representationType, JsonRepresentation representation) {
        super(resourceContext, linkFollower, representationType, representation);
    }

    public ObjectSpecification getParentSpecification() {
        return this.objectSpecification;
    }

    public T getObjectFeature() {
        return this.objectFeature;
    }

    @Override
    public AbstractTypeFeatureReprRenderer<T> with(ParentSpecAndFeature<T> specAndFeature) {
        this.objectSpecification = specAndFeature.getParentSpec();
        this.objectFeature = specAndFeature.getObjectFeature();
        return this;
    }

    @Override
    public JsonRepresentation render() {
        this.addLinkSelfIfRequired();
        this.addLinkUpToParent();
        this.addPropertiesSpecificToFeature();
        this.addLinksSpecificToFeature();
        this.putExtensionsSpecificToFeature();
        return this.representation;
    }

    protected void addPropertiesSpecificToFeature() {
    }

    protected abstract void addLinkSelfIfRequired();

    protected abstract void addLinkUpToParent();

    protected void addLinksSpecificToFeature() {
    }

    protected abstract void putExtensionsSpecificToFeature();

    protected void putExtensionsName() {
        this.getObjectFeature().getStaticOrCanonicalFriendlyName().accept(staticForm -> {
            this.getExtensions().mapPut("friendlyName", staticForm);
            this.getExtensions().mapPut("friendlyNameForm", "static");
        }, canonicalForm -> {
            this.getExtensions().mapPut("friendlyName", canonicalForm);
            this.getExtensions().mapPut("friendlyNameForm", "canonical");
        });
    }

    protected void putExtensionsDescriptionIfAvailable() {
        this.getObjectFeature().getStaticOrCanonicalDescription().ifPresent(description -> description.accept(staticForm -> {
            if (staticForm.isEmpty()) {
                return;
            }
            this.getExtensions().mapPut("description", staticForm);
            this.getExtensions().mapPut("descriptionForm", "static");
        }, canonicalForm -> {
            if (canonicalForm.isEmpty()) {
                return;
            }
            this.getExtensions().mapPut("description", canonicalForm);
            this.getExtensions().mapPut("descriptionForm", "canonical");
        }));
    }
}

