/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domaintypes;

import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.AbstractTypeMemberReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.DomainTypeReprRenderer;

public class CollectionDescriptionReprRenderer
extends AbstractTypeMemberReprRenderer<OneToManyAssociation> {
    public static LinkBuilder newLinkToBuilder(IResourceContext resourceContext, Rel rel, ObjectSpecification objectSpecification, OneToManyAssociation collection) {
        String domainType = objectSpecification.getLogicalTypeName();
        String collectionId = collection.getId();
        String url = "domain-types/" + domainType + "/collections/" + collectionId;
        return LinkBuilder.newBuilder(resourceContext, rel.getName(), RepresentationType.COLLECTION_DESCRIPTION, url, new Object[0]);
    }

    public CollectionDescriptionReprRenderer(IResourceContext resourceContext, LinkFollowSpecs linkFollower, JsonRepresentation representation) {
        super(resourceContext, linkFollower, RepresentationType.COLLECTION_DESCRIPTION, representation);
    }

    @Override
    protected void addLinksSpecificToFeature() {
        this.addLinkToElementTypeIfAny();
    }

    @Override
    protected void putExtensionsSpecificToFeature() {
        this.putExtensionsName();
        this.putExtensionsDescriptionIfAvailable();
    }

    private void addLinkToElementTypeIfAny() {
        ObjectSpecification elementTypeSpec = ((OneToManyAssociation)this.getObjectFeature()).getElementType();
        if (elementTypeSpec == null) {
            return;
        }
        this.getLinks().arrayAdd(DomainTypeReprRenderer.newLinkToBuilder(this.getResourceContext(), Rel.ELEMENT_TYPE, elementTypeSpec).build());
    }
}

