/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domaintypes;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.MixedIn;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRendererAbstract;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.ActionDescriptionReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.CollectionDescriptionReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.PropertyDescriptionReprRenderer;

public class DomainTypeReprRenderer
extends ReprRendererAbstract<ObjectSpecification> {
    private ObjectSpecification objectSpecification;

    public static LinkBuilder newLinkToBuilder(IResourceContext resourceContext, Rel rel, ObjectSpecification objectSpec) {
        String typeFullName = objectSpec.getLogicalTypeName();
        String url = String.format("domain-types/%s", typeFullName);
        return LinkBuilder.newBuilder(resourceContext, rel.getName(), RepresentationType.DOMAIN_TYPE, url, new Object[0]);
    }

    public static LinkBuilder newLinkToLayoutBuilder(IResourceContext resourceContext, ObjectSpecification objectSpec) {
        Rel rel = Rel.LAYOUT;
        String typeFullName = objectSpec.getLogicalTypeName();
        String url = String.format("domain-types/%s/layout", typeFullName);
        return LinkBuilder.newBuilder(resourceContext, rel.getName(), RepresentationType.LAYOUT, url, new Object[0]);
    }

    public DomainTypeReprRenderer(IResourceContext resourceContext, LinkFollowSpecs linkFollower, JsonRepresentation representation) {
        super(resourceContext, linkFollower, RepresentationType.DOMAIN_TYPE, representation);
    }

    public DomainTypeReprRenderer with(ObjectSpecification objectSpecification) {
        this.objectSpecification = objectSpecification;
        return this;
    }

    @Override
    public JsonRepresentation render() {
        if (this.objectSpecification == null) {
            throw new IllegalStateException("ObjectSpecification not specified");
        }
        if (this.includesSelf) {
            JsonRepresentation selfLink = DomainTypeReprRenderer.newLinkToBuilder(this.getResourceContext(), Rel.SELF, this.objectSpecification).build();
            this.getLinks().arrayAdd(selfLink);
            JsonRepresentation layoutLink = DomainTypeReprRenderer.newLinkToLayoutBuilder(this.getResourceContext(), this.objectSpecification).build();
            this.getLinks().arrayAdd(layoutLink);
        }
        this.representation.mapPut("canonicalName", this.objectSpecification.getFullIdentifier());
        this.addMembers();
        this.addTypeActions();
        this.putExtensionsNames();
        this.putExtensionsDescriptionIfAvailable();
        this.putExtensionsIfService();
        return this.representation;
    }

    private void addMembers() {
        JsonRepresentation membersMap = JsonRepresentation.newMap((String[])new String[0]);
        this.representation.mapPut("members", membersMap);
        this.objectSpecification.streamProperties(MixedIn.INCLUDED).forEach(property -> membersMap.mapPut(property.getId(), PropertyDescriptionReprRenderer.newLinkToBuilder(this.getResourceContext(), Rel.PROPERTY, this.objectSpecification, property).build()));
        this.objectSpecification.streamCollections(MixedIn.INCLUDED).forEach(collection -> membersMap.mapPut(collection.getId(), CollectionDescriptionReprRenderer.newLinkToBuilder(this.getResourceContext(), Rel.COLLECTION, this.objectSpecification, collection).build()));
        this.objectSpecification.streamAnyActions(MixedIn.INCLUDED).forEach(action -> membersMap.mapPut(action.getId(), ActionDescriptionReprRenderer.newLinkToBuilder(this.getResourceContext(), Rel.ACTION, this.objectSpecification, action).build()));
    }

    private JsonRepresentation getTypeActions() {
        JsonRepresentation typeActions = this.representation.getMap("typeActions");
        if (typeActions == null) {
            typeActions = JsonRepresentation.newMap((String[])new String[0]);
            this.representation.mapPut("typeActions", typeActions);
        }
        return typeActions;
    }

    private void addTypeActions() {
        JsonRepresentation typeActions = this.getTypeActions();
        typeActions.mapPut("isSubtypeOf", this.linkToIsSubtypeOf());
        typeActions.mapPut("isSupertypeOf", this.linkToIsSupertypeOf());
    }

    private JsonRepresentation linkToIsSubtypeOf() {
        String url = "domain-types/" + this.objectSpecification.getLogicalTypeName() + "/type-actions/isSubtypeOf/invoke";
        LinkBuilder linkBuilder = LinkBuilder.newBuilder(this.getResourceContext(), Rel.INVOKE.andParam("typeaction", "isSubtypeOf"), RepresentationType.TYPE_ACTION_RESULT, url, new Object[0]);
        JsonRepresentation arguments = DomainTypeReprRenderer.argumentsTo(this.getResourceContext(), "supertype", null);
        JsonRepresentation link = linkBuilder.withArguments(arguments).build();
        return link;
    }

    private JsonRepresentation linkToIsSupertypeOf() {
        String url = "domain-types/" + this.objectSpecification.getLogicalTypeName() + "/type-actions/isSupertypeOf/invoke";
        LinkBuilder linkBuilder = LinkBuilder.newBuilder(this.getResourceContext(), Rel.INVOKE.andParam("typeaction", "isSupertypeOf"), RepresentationType.TYPE_ACTION_RESULT, url, new Object[0]);
        JsonRepresentation arguments = DomainTypeReprRenderer.argumentsTo(this.getResourceContext(), "subtype", null);
        JsonRepresentation link = linkBuilder.withArguments(arguments).build();
        return link;
    }

    public static JsonRepresentation argumentsTo(IResourceContext resourceContext, String paramName, ObjectSpecification objectSpec) {
        JsonRepresentation arguments = JsonRepresentation.newMap((String[])new String[0]);
        JsonRepresentation link = JsonRepresentation.newMap((String[])new String[0]);
        arguments.mapPut(paramName, link);
        if (objectSpec != null) {
            link.mapPut("href", resourceContext.restfulUrlFor("domain-types/" + objectSpec.getLogicalTypeName()));
        } else {
            link.mapPut("href", (JsonNode)NullNode.instance);
        }
        return arguments;
    }

    protected void putExtensionsNames() {
        String singularName = this.objectSpecification.getSingularName();
        this.getExtensions().mapPut("friendlyName", singularName);
        String pluralName = this.objectSpecification.getPluralName();
        this.getExtensions().mapPut("pluralName", pluralName);
    }

    protected void putExtensionsDescriptionIfAvailable() {
        String description = this.objectSpecification.getDescription();
        if (!_Strings.isNullOrEmpty((CharSequence)description)) {
            this.getExtensions().mapPut("description", description);
        }
    }

    protected void putExtensionsIfService() {
        this.getExtensions().mapPut("isService", this.objectSpecification.isManagedBean());
    }
}

