/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domaintypes;

import org.apache.isis.commons.collections.Can;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRendererAbstract;

public class TypeListReprRenderer
extends ReprRendererAbstract<Can<ObjectSpecification>> {
    private Can<ObjectSpecification> specifications;

    public TypeListReprRenderer(IResourceContext resourceContext, LinkFollowSpecs linkFollower, JsonRepresentation representation) {
        super(resourceContext, linkFollower, RepresentationType.TYPE_LIST, representation);
    }

    public TypeListReprRenderer with(Can<ObjectSpecification> specifications) {
        this.specifications = specifications;
        return this;
    }

    @Override
    public JsonRepresentation render() {
        if (this.includesSelf) {
            this.withLink(Rel.SELF, "domain-types");
        }
        JsonRepresentation specList = JsonRepresentation.newArray();
        for (ObjectSpecification objectSpec : this.specifications) {
            LinkBuilder linkBuilder = LinkBuilder.newBuilder(this.getResourceContext(), Rel.DOMAIN_TYPE.getName(), RepresentationType.DOMAIN_TYPE, "domain-types/%s", objectSpec.getLogicalTypeName());
            specList.arrayAdd(linkBuilder.build());
        }
        this.representation.mapPut("values", specList);
        this.getExtensions();
        return this.representation;
    }
}

