/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service.conneg;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.POJONode;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Priority;
import javax.inject.Named;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.client.RepresentationTypeSimplifiedV2;
import org.apache.isis.applib.client.SuppressionType;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.interactions.managed.ManagedAction;
import org.apache.isis.core.metamodel.interactions.managed.ManagedCollection;
import org.apache.isis.core.metamodel.interactions.managed.ManagedMember;
import org.apache.isis.core.metamodel.interactions.managed.ManagedProperty;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ManagedObjects;
import org.apache.isis.core.metamodel.spec.feature.MixedIn;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.ActionResultRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.dtos.ScalarValueDtoV2;
import org.apache.isis.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.isis.viewer.restfulobjects.rendering.Responses;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.AbstractObjectMemberReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndActionInvocation;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectPropertyReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.service.conneg.ContentNegotiationServiceAbstract;
import org.apache.isis.viewer.restfulobjects.rendering.service.conneg.ContentNegotiationServiceForRestfulObjectsV1_0;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.viewer.ro.ContentNegotiationServiceOrgApacheIsisV2")
@Priority(value=0x3FFFFF37)
@Qualifier(value="OrgApacheIsisV2")
public class ContentNegotiationServiceOrgApacheIsisV2
extends ContentNegotiationServiceAbstract {
    public static final String ACCEPT_PROFILE = "urn:org.apache.isis/v2";
    private final ContentNegotiationServiceForRestfulObjectsV1_0 restfulObjectsV1_0;

    public ContentNegotiationServiceOrgApacheIsisV2(ContentNegotiationServiceForRestfulObjectsV1_0 restfulObjectsV1_0) {
        this.restfulObjectsV1_0 = restfulObjectsV1_0;
    }

    @Override
    public Response.ResponseBuilder buildResponse(IResourceContext resourceContext, ManagedObject objectAdapter) {
        JsonRepresentation $$roRepresentation;
        boolean canAccept = this.canAccept(resourceContext);
        if (!canAccept) {
            return null;
        }
        EnumSet<SuppressionType> suppression = this.suppress(resourceContext);
        boolean suppressRO = suppression.contains(SuppressionType.RO);
        JsonRepresentation rootRepresentation = JsonRepresentation.newMap((String[])new String[0]);
        this.appendObjectTo(resourceContext, objectAdapter, rootRepresentation, suppression);
        if (!suppressRO) {
            $$roRepresentation = JsonRepresentation.newMap((String[])new String[0]);
            rootRepresentation.mapPut("$$ro", $$roRepresentation);
        } else {
            $$roRepresentation = null;
        }
        Response.ResponseBuilder responseBuilder = this.restfulObjectsV1_0.buildResponseTo(resourceContext, objectAdapter, $$roRepresentation, rootRepresentation);
        responseBuilder.type(RepresentationTypeSimplifiedV2.OBJECT.getContentTypeHeaderValue(ACCEPT_PROFILE));
        return this.responseBuilder(responseBuilder);
    }

    @Override
    public Response.ResponseBuilder buildResponse(IResourceContext resourceContext, ManagedProperty objectAndProperty) {
        return null;
    }

    @Override
    public Response.ResponseBuilder buildResponse(IResourceContext resourceContext, ManagedCollection managedCollection) {
        JsonRepresentation $$roRepresentation;
        if (!this.canAccept(resourceContext)) {
            return null;
        }
        EnumSet<SuppressionType> suppression = this.suppress(resourceContext);
        boolean suppressRO = suppression.contains(SuppressionType.RO);
        JsonRepresentation rootRepresentation = JsonRepresentation.newArray();
        this.appendCollectionTo(resourceContext, managedCollection, rootRepresentation, suppression);
        if (!suppressRO) {
            JsonRepresentation $$roContainerRepresentation = JsonRepresentation.newMap((String[])new String[0]);
            rootRepresentation.arrayAdd($$roContainerRepresentation);
            $$roRepresentation = JsonRepresentation.newMap((String[])new String[0]);
            $$roContainerRepresentation.mapPut("$$ro", $$roRepresentation);
        } else {
            $$roRepresentation = null;
        }
        Response.ResponseBuilder responseBuilder = this.restfulObjectsV1_0.buildResponseTo(resourceContext, managedCollection, $$roRepresentation, rootRepresentation);
        responseBuilder.type(RepresentationTypeSimplifiedV2.OBJECT_COLLECTION.getContentTypeHeaderValue(ACCEPT_PROFILE));
        return this.responseBuilder(responseBuilder);
    }

    @Override
    public Response.ResponseBuilder buildResponse(IResourceContext resourceContext, ManagedAction objectAndAction) {
        return null;
    }

    @Override
    public Response.ResponseBuilder buildResponse(IResourceContext resourceContext, ObjectAndActionInvocation objectAndActionInvocation) {
        RepresentationTypeSimplifiedV2 headerContentType;
        JsonRepresentation rootRepresentation;
        if (!this.canAccept(resourceContext)) {
            return null;
        }
        EnumSet<SuppressionType> suppression = this.suppress(resourceContext);
        boolean suppressRO = suppression.contains(SuppressionType.RO);
        JsonRepresentation $$roRepresentation = suppressRO ? null : JsonRepresentation.newMap((String[])new String[0]);
        ManagedObject returnedAdapter = objectAndActionInvocation.getReturnedAdapter();
        ActionResultRepresentation.ResultType resultType = objectAndActionInvocation.determineResultType();
        switch (resultType) {
            case DOMAIN_OBJECT: {
                if (ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)returnedAdapter)) {
                    return Responses.ofNotFound();
                }
                rootRepresentation = JsonRepresentation.newMap((String[])new String[0]);
                this.appendObjectTo(resourceContext, returnedAdapter, rootRepresentation, suppression);
                headerContentType = RepresentationTypeSimplifiedV2.OBJECT;
                break;
            }
            case LIST: {
                if (!objectAndActionInvocation.hasElements()) {
                    return Responses.ofNotFound();
                }
                rootRepresentation = JsonRepresentation.newArray();
                objectAndActionInvocation.streamElementAdapters().forEach(elementAdapter -> this.appendElementTo(resourceContext, (ManagedObject)elementAdapter, rootRepresentation, suppression));
                if (!suppressRO) {
                    JsonRepresentation $$roContainerRepresentation = JsonRepresentation.newMap((String[])new String[0]);
                    rootRepresentation.arrayAdd($$roContainerRepresentation);
                    $$roContainerRepresentation.mapPut("$$ro", $$roRepresentation);
                }
                headerContentType = RepresentationTypeSimplifiedV2.LIST;
                break;
            }
            case SCALAR_VALUES: {
                if (!objectAndActionInvocation.hasElements()) {
                    return Responses.ofNotFound();
                }
                rootRepresentation = JsonRepresentation.newArray();
                objectAndActionInvocation.streamElementAdapters().map(elementAdapter -> {
                    Object pojo = elementAdapter.getPojo();
                    return pojo == null ? ScalarValueDtoV2.forNull((Class)elementAdapter.getSpecification().getCorrespondingClass()) : ScalarValueDtoV2.forValue((Object)pojo);
                }).forEach(arg_0 -> ((JsonRepresentation)rootRepresentation).arrayAdd(arg_0));
                headerContentType = RepresentationTypeSimplifiedV2.VALUES;
                break;
            }
            case SCALAR_VALUE: {
                Object pojo = returnedAdapter.getPojo();
                if (pojo == null) {
                    return Responses.ofNotFound();
                }
                ScalarValueDtoV2 dto = ScalarValueDtoV2.forValue((Object)pojo);
                rootRepresentation = new JsonRepresentation((JsonNode)new POJONode((Object)dto));
                headerContentType = RepresentationTypeSimplifiedV2.VALUE;
                break;
            }
            case VOID: {
                rootRepresentation = JsonRepresentation.newArray();
                headerContentType = RepresentationTypeSimplifiedV2.VOID;
                break;
            }
            default: {
                throw _Exceptions.unmatchedCase((Object)resultType);
            }
        }
        Response.ResponseBuilder responseBuilder = this.restfulObjectsV1_0.buildResponseTo(resourceContext, objectAndActionInvocation, $$roRepresentation, rootRepresentation).type(headerContentType.getContentTypeHeaderValue(ACCEPT_PROFILE));
        return this.responseBuilder(responseBuilder);
    }

    protected Response.ResponseBuilder responseBuilder(Response.ResponseBuilder responseBuilder) {
        return responseBuilder;
    }

    boolean canAccept(IResourceContext resourceContext) {
        List<MediaType> acceptableMediaTypes = resourceContext.getAcceptableMediaTypes();
        return this.mediaTypeParameterMatches(acceptableMediaTypes, "profile", ACCEPT_PROFILE);
    }

    protected EnumSet<SuppressionType> suppress(IResourceContext resourceContext) {
        List<MediaType> acceptableMediaTypes = resourceContext.getAcceptableMediaTypes();
        return SuppressionType.ParseUtil.parse(this.mediaTypeParameterList(acceptableMediaTypes, "suppress"));
    }

    private void appendObjectTo(IResourceContext resourceContext, ManagedObject owner, JsonRepresentation rootRepresentation, EnumSet<SuppressionType> suppression) {
        this.appendPropertiesTo(resourceContext, owner, rootRepresentation, suppression);
        Where where = resourceContext.getWhere();
        owner.getSpecification().streamCollections(MixedIn.INCLUDED).forEach(collection -> {
            JsonRepresentation collectionRepresentation = JsonRepresentation.newArray();
            rootRepresentation.mapPut(collection.getId(), collectionRepresentation);
            InteractionInitiatedBy interactionInitiatedBy = resourceContext.getInteractionInitiatedBy();
            Consent visibilityConsent = collection.isVisible(owner, interactionInitiatedBy, where);
            if (!visibilityConsent.isAllowed()) {
                return;
            }
            ManagedCollection managedCollection = ManagedCollection.of((ManagedObject)owner, (OneToManyAssociation)collection, (Where)where);
            this.appendCollectionTo(resourceContext, managedCollection, collectionRepresentation, suppression);
        });
    }

    private void appendPropertiesTo(IResourceContext resourceContext, ManagedObject objectAdapter, JsonRepresentation rootRepresentation, EnumSet<SuppressionType> suppression) {
        InteractionInitiatedBy interactionInitiatedBy = resourceContext.getInteractionInitiatedBy();
        Where where = resourceContext.getWhere();
        Stream properties = objectAdapter.getSpecification().streamProperties(MixedIn.INCLUDED);
        properties.forEach(property -> {
            String[] parts;
            String upHref;
            Consent visibility = property.isVisible(objectAdapter, interactionInitiatedBy, where);
            if (!visibility.isAllowed()) {
                return;
            }
            JsonRepresentation propertyRepresentation = JsonRepresentation.newMap((String[])new String[0]);
            AbstractObjectMemberReprRenderer renderer = new ObjectPropertyReprRenderer(resourceContext, null, property.getId(), propertyRepresentation).asStandalone().with((ManagedMember)ManagedProperty.of((ManagedObject)objectAdapter, (OneToOneAssociation)property, (Where)where));
            JsonRepresentation propertyValueRepresentation = renderer.render();
            if (!suppression.contains(SuppressionType.HREF)) {
                upHref = propertyValueRepresentation.getString("links[rel=up].href");
                rootRepresentation.mapPut("$$href", upHref);
            }
            if (!suppression.contains(SuppressionType.TITLE)) {
                String upTitle = propertyValueRepresentation.getString("links[rel=up].title");
                rootRepresentation.mapPut("$$title", upTitle);
            }
            if (!suppression.contains(SuppressionType.DOMAIN_TYPE) && (parts = (upHref = propertyValueRepresentation.getString("links[rel=up].href")).split("[/]")).length > 2) {
                String upObjectType = parts[parts.length - 2];
                rootRepresentation.mapPut("$$domainType", upObjectType);
            }
            if (!suppression.contains(SuppressionType.ID) && (parts = (upHref = propertyValueRepresentation.getString("links[rel=up].href")).split("[/]")).length > 1) {
                String upInstanceId = parts[parts.length - 1];
                rootRepresentation.mapPut("$$instanceId", upInstanceId);
            }
            JsonRepresentation value = propertyValueRepresentation.getRepresentation("value", new Object[0]);
            rootRepresentation.mapPut(property.getId(), value);
        });
    }

    private void appendCollectionTo(IResourceContext resourceContext, ManagedCollection managedCollection, JsonRepresentation representation, EnumSet<SuppressionType> suppression) {
        managedCollection.streamElements(resourceContext.getInteractionInitiatedBy()).forEach(element -> this.appendElementTo(resourceContext, (ManagedObject)element, representation, suppression));
    }

    private void appendElementTo(IResourceContext resourceContext, ManagedObject elementAdapter, JsonRepresentation collectionRepresentation, EnumSet<SuppressionType> suppression) {
        JsonRepresentation elementRepresentation = JsonRepresentation.newMap((String[])new String[0]);
        this.appendPropertiesTo(resourceContext, elementAdapter, elementRepresentation, suppression);
        collectionRepresentation.arrayAdd(elementRepresentation);
    }
}

