/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service.conneg;

import java.util.List;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.services.conmap.ContentMappingService;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndActionInvocation;
import org.apache.isis.viewer.restfulobjects.rendering.service.conneg.ContentNegotiationServiceAbstract;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.viewer.ro.ContentNegotiationServiceXRoDomainType")
@Priority(value=1073741723)
@Qualifier(value="XRoDomainType")
public class ContentNegotiationServiceXRoDomainType
extends ContentNegotiationServiceAbstract {
    public static final String X_RO_DOMAIN_TYPE = "x-ro-domain-type";
    @Inject
    private List<ContentMappingService> contentMappingServices;

    @Override
    public Response.ResponseBuilder buildResponse(IResourceContext resourceContext, ManagedObject objectAdapter) {
        Object domainObject = this.objectOf(objectAdapter);
        RepresentationType representationType = RepresentationType.DOMAIN_OBJECT;
        MediaType mediaType = this.mediaTypeFrom(resourceContext, representationType);
        if (mediaType == null) {
            return null;
        }
        return this.buildResponse(resourceContext, domainObject, representationType);
    }

    protected MediaType mediaTypeFrom(IResourceContext renderContext, RepresentationType representationType) {
        List<MediaType> acceptableMediaTypes = renderContext.getAcceptableMediaTypes();
        MediaType mediaType = representationType.matchesXmlProfileWithParameter(acceptableMediaTypes, X_RO_DOMAIN_TYPE);
        if (mediaType == null) {
            mediaType = representationType.matchesJsonProfileWithParameter(acceptableMediaTypes, X_RO_DOMAIN_TYPE);
        }
        return mediaType;
    }

    @Override
    public Response.ResponseBuilder buildResponse(IResourceContext resourceContext, ObjectAndActionInvocation objectAndActionInvocation) {
        RepresentationType representationType = RepresentationType.ACTION_RESULT;
        MediaType mediaType = this.mediaTypeFrom(resourceContext, representationType);
        if (mediaType == null) {
            return null;
        }
        Object domainObject = this.returnedObjectOf(objectAndActionInvocation);
        if (domainObject == null) {
            throw RestfulObjectsApplicationException.create(RestfulResponse.HttpStatusCode.NOT_FOUND);
        }
        return this.buildResponse(resourceContext, domainObject, representationType);
    }

    protected Response.ResponseBuilder buildResponse(IResourceContext renderContext, Object domainObject, RepresentationType representationType) {
        List<MediaType> acceptableMediaTypes = renderContext.getAcceptableMediaTypes();
        MediaType mediaType = this.mediaTypeFrom(renderContext, representationType);
        if (mediaType == null) {
            return null;
        }
        String xRoDomainType = (String)mediaType.getParameters().get(X_RO_DOMAIN_TYPE);
        Class<?> domainType = this.loadClass(xRoDomainType);
        Object mappedDomainObject = this.map(domainObject, acceptableMediaTypes);
        this.ensureDomainObjectAssignable(xRoDomainType, domainType, mappedDomainObject);
        if ("xml".equals(mediaType.getSubtype())) {
            this.ensureJaxbAnnotated(mappedDomainObject.getClass());
        }
        return Response.ok((Object)mappedDomainObject, (MediaType)mediaType);
    }

    protected Object map(Object domainObject, List<MediaType> acceptableMediaTypes) {
        for (ContentMappingService contentMappingService : this.contentMappingServices) {
            Object mappedObject = contentMappingService.map(domainObject, acceptableMediaTypes);
            if (mappedObject == null) continue;
            return mappedObject;
        }
        return domainObject;
    }
}

