/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service.swagger;

import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.isis.applib.services.swagger.Format;
import org.apache.isis.applib.services.swagger.SwaggerService;
import org.apache.isis.applib.services.swagger.Visibility;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.config.RestEasyConfiguration;
import org.apache.isis.core.config.viewer.web.WebAppContextPath;
import org.apache.isis.viewer.restfulobjects.rendering.service.swagger.internal.SwaggerSpecGenerator;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.metamodel.swaggerServiceDefault")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="Default")
public class SwaggerServiceDefault
implements SwaggerService {
    private final SwaggerSpecGenerator swaggerSpecGenerator;
    private final String basePath;

    @Inject
    public SwaggerServiceDefault(SwaggerSpecGenerator swaggerSpecGenerator, RestEasyConfiguration restEasyConfiguration, WebAppContextPath webAppContextPath) {
        this.swaggerSpecGenerator = swaggerSpecGenerator;
        String restfulPath = restEasyConfiguration.getJaxrs().getDefaultPath();
        String restfulBase = webAppContextPath.prependContextPath(restfulPath);
        this.basePath = _Strings.suffix((String)restfulBase, (String)"/");
    }

    public String generateSwaggerSpec(Visibility visibility, Format format) {
        return this.swaggerSpecGenerator.generate(this.basePath, visibility, format);
    }
}

