/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service.swagger;

import java.util.Optional;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.isis.applib.IsisModuleApplib;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.MemberSupport;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.registry.ServiceRegistry;
import org.apache.isis.applib.services.swagger.Format;
import org.apache.isis.applib.services.swagger.SwaggerService;
import org.apache.isis.applib.services.swagger.Visibility;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.applib.value.LocalResourcePath;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.config.RestEasyConfiguration;

@Named(value="isis.viewer.restfulobjects.SwaggerServiceMenu")
@DomainService(logicalTypeName="isis.viewer.restfulobjects.SwaggerServiceMenu")
@DomainServiceLayout(named="Prototyping", menuBar=DomainServiceLayout.MenuBar.SECONDARY)
@Priority(value=0x1FFFFFFF)
public class SwaggerServiceMenu {
    public static final String LOGICAL_TYPE_NAME = "isis.viewer.restfulobjects.SwaggerServiceMenu";
    private final SwaggerService swaggerService;
    private final ServiceRegistry serviceRegistry;
    private final RestEasyConfiguration restEasyConfiguration;
    private final String basePath;

    @Inject
    public SwaggerServiceMenu(SwaggerService swaggerService, ServiceRegistry serviceRegistry, RestEasyConfiguration restEasyConfiguration) {
        this.swaggerService = swaggerService;
        this.serviceRegistry = serviceRegistry;
        this.restEasyConfiguration = restEasyConfiguration;
        this.basePath = this.restEasyConfiguration.getJaxrs().getDefaultPath() + "/";
    }

    @Programmatic
    String disableReasonWhenRequiresROViewer() {
        Optional moduleIfAny = this.serviceRegistry.lookupBeanById("isis.viewer.ro.WebModuleJaxrsRestEasy4");
        return moduleIfAny.isPresent() ? null : "RestfulObjects viewer is not configured";
    }

    private static String buildFileName(String fileNamePrefix, Visibility visibility, Format format) {
        String formatLower = format.name().toLowerCase();
        int i = fileNamePrefix.lastIndexOf("." + formatLower);
        if (i > 0) {
            fileNamePrefix = fileNamePrefix.substring(0, i);
        }
        return _Strings.asFileNameWithExtension((String)(fileNamePrefix + "-" + visibility.name().toLowerCase()), (String)formatLower);
    }

    @Action(semantics=SemanticsOf.SAFE, domainEvent=ActionEvent.class, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-download", sequence="500.600.3")
    public class downloadSwaggerSchemaDefinition {
        @MemberSupport
        public Clob act(@ParameterLayout(named="Filename") String fileNamePrefix, Visibility visibility, Format format) {
            String fileName = SwaggerServiceMenu.buildFileName(fileNamePrefix, visibility, format);
            String spec = SwaggerServiceMenu.this.swaggerService.generateSwaggerSpec(visibility, format);
            return new Clob(fileName, format.mediaType(), (CharSequence)spec);
        }

        @MemberSupport
        public String default0Act() {
            return "swagger";
        }

        @MemberSupport
        public Visibility default1Act() {
            return Visibility.PRIVATE;
        }

        @MemberSupport
        public Format default2Act() {
            return Format.YAML;
        }

        public class ActionEvent
        extends ActionDomainEvent<downloadSwaggerSchemaDefinition> {
        }
    }

    @Action(semantics=SemanticsOf.SAFE, domainEvent=ActionEvent.class, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-external-link-alt", sequence="500.600.2")
    public class openRestApi {
        @MemberSupport
        public LocalResourcePath act() {
            return new LocalResourcePath(SwaggerServiceMenu.this.basePath);
        }

        @MemberSupport
        public String disableAct() {
            return SwaggerServiceMenu.this.disableReasonWhenRequiresROViewer();
        }

        public class ActionEvent
        extends ActionDomainEvent<openRestApi> {
        }
    }

    @Action(semantics=SemanticsOf.SAFE, domainEvent=ActionEvent.class, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-external-link-alt", sequence="500.600.1")
    public class openSwaggerUi {
        @MemberSupport
        public LocalResourcePath act() {
            return new LocalResourcePath("/swagger-ui/index.thtml");
        }

        @MemberSupport
        public String disableAct() {
            return SwaggerServiceMenu.this.disableReasonWhenRequiresROViewer();
        }

        public class ActionEvent
        extends ActionDomainEvent<openSwaggerUi> {
        }
    }

    public static abstract class ActionDomainEvent<T>
    extends IsisModuleApplib.ActionDomainEvent<T> {
    }
}

