/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service.swagger.internal;

import java.util.Set;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.viewer.restfulobjects.rendering.service.swagger.internal.ClassExcluder;

public abstract class ClassExcluderAbstract
implements ClassExcluder {
    private final Set<String> packageNamesToIgnore = _Sets.newHashSet();

    protected void ignorePackage(String packageName) {
        this.packageNamesToIgnore.add(packageName);
    }

    @Override
    public boolean exclude(ObjectSpecification objectSpec) {
        if (objectSpec == null) {
            return false;
        }
        return this.packageNamesToIgnore.stream().anyMatch(packageName -> objectSpec.getCorrespondingClass().getName().startsWith((String)packageName));
    }

    @Override
    public boolean exclude(ObjectAction objectAction) {
        ObjectSpecification returnType = objectAction.getReturnType();
        if (this.exclude(returnType)) {
            return true;
        }
        Can parameterTypes = objectAction.getParameterTypes();
        for (ObjectSpecification parameterType : parameterTypes) {
            if (!this.exclude(parameterType)) continue;
            return true;
        }
        return false;
    }
}

