/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service.swagger.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.viewer.restfulobjects.rendering.service.swagger.internal.Tagger;
import org.springframework.stereotype.Component;

@Component
@Named(value="isis.metamodel.TaggerDefault")
public class TaggerDefault
implements Tagger {
    static Pattern tagPatternForFqcn = Pattern.compile("^.*\\.([^\\.]+)\\.([^\\.]+)$");
    static Pattern tagPatternForTwoParts = Pattern.compile("^([^\\.]+)\\.([^\\.]+)$");
    static Pattern tagPatternForJaxbDto = Pattern.compile("^.*\\.([^\\.]+)\\.(v[0-9][^\\.]*)\\.([^\\.]+)$");

    @Override
    @Programmatic
    public String tagForLogicalTypeName(String logicalTypeName, String fallback) {
        if (logicalTypeName.startsWith("org.apache.isis.")) {
            return ". apache isis internals";
        }
        if (logicalTypeName.startsWith("isis.applib.")) {
            return ". apache isis applib";
        }
        if (logicalTypeName.startsWith("isis.conf.")) {
            return ". apache isis conf";
        }
        if (logicalTypeName.startsWith("isis.sudo.")) {
            return ". apache isis sudo";
        }
        if (logicalTypeName.startsWith("isis.persistence.")) {
            return ". apache isis persistence - " + TaggerDefault.partsOf(logicalTypeName).skip(2L).limit(1L).collect(Collectors.joining("."));
        }
        if (logicalTypeName.startsWith("isis.security.")) {
            return ". apache isis security";
        }
        if (logicalTypeName.startsWith("isis.ext.")) {
            return ". apache isis extensions - " + TaggerDefault.partsOf(logicalTypeName).skip(2L).limit(1L).collect(Collectors.joining("."));
        }
        if (logicalTypeName.startsWith("isis.sub.")) {
            return ". apache isis subdomains - " + TaggerDefault.partsOf(logicalTypeName).skip(2L).limit(1L).collect(Collectors.joining("."));
        }
        if (logicalTypeName.startsWith("org.springframework.")) {
            return "> spring framework " + TaggerDefault.partsOf(logicalTypeName).skip(2L).limit(1L).collect(Collectors.joining("."));
        }
        Matcher matcher = tagPatternForJaxbDto.matcher(logicalTypeName);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        matcher = tagPatternForFqcn.matcher(logicalTypeName);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        matcher = tagPatternForTwoParts.matcher(logicalTypeName);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return fallback != null ? fallback : logicalTypeName;
    }

    private static Stream<String> partsOf(String logicalTypeName) {
        return _Strings.splitThenStream((String)logicalTypeName, (String)".");
    }
}

