/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.viewer.context;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Providers;
import lombok.NonNull;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.commons.internal.primitives._Ints;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ManagedObjects;
import org.apache.isis.core.runtime.context.RuntimeContextBase;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.RestfulRequest;
import org.apache.isis.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAdapterLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.rendering.util.Util;
import org.apache.isis.viewer.restfulobjects.viewer.resources.ResourceDescriptor;
import org.apache.isis.viewer.restfulobjects.viewer.resources.serialization.SerializationStrategy;

public class ResourceContext
extends RuntimeContextBase
implements IResourceContext {
    private final HttpHeaders httpHeaders;
    private final Request request;
    private final HttpServletRequest httpServletRequest;
    private final HttpServletResponse httpServletResponse;
    private final SecurityContext securityContext;
    private final String applicationAbsoluteBase;
    private final String restfulAbsoluteBase;
    private List<List<String>> followLinks;
    private boolean validateOnly;
    private final Where where;
    private final RepresentationService.Intent intent;
    private final InteractionInitiatedBy interactionInitiatedBy;
    private final String urlUnencodedQueryString;
    private final JsonRepresentation readQueryStringAsMap;
    private Set<Bookmark> rendered = _Sets.newHashSet();
    private ObjectAdapterLinkTo objectAdapterLinkTo;

    public ResourceContext(ResourceDescriptor resourceDescriptor, HttpHeaders httpHeaders, Providers providers, Request request, String applicationAbsoluteBase, String restfulAbsoluteBase, String urlUnencodedQueryStringIfAny, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SecurityContext securityContext, MetaModelContext metaModelContext, InteractionInitiatedBy interactionInitiatedBy, Map<String, String[]> requestParams) {
        super(metaModelContext);
        this.httpHeaders = httpHeaders;
        this.request = request;
        this.where = resourceDescriptor.getWhere();
        this.intent = resourceDescriptor.getIntent();
        this.urlUnencodedQueryString = urlUnencodedQueryStringIfAny;
        this.httpServletRequest = httpServletRequest;
        this.httpServletResponse = httpServletResponse;
        this.securityContext = securityContext;
        this.interactionInitiatedBy = interactionInitiatedBy;
        this.applicationAbsoluteBase = _Strings.suffix((String)applicationAbsoluteBase, (String)"/");
        this.restfulAbsoluteBase = _Strings.suffix((String)restfulAbsoluteBase, (String)"/");
        this.readQueryStringAsMap = this.requestArgsAsMap(requestParams);
        this.init(resourceDescriptor.getRepresentationType());
    }

    void init(RepresentationType representationType) {
        this.ensureDomainModelQueryParamSupported();
        this.followLinks = Collections.unmodifiableList((List)this.getArg(RestfulRequest.RequestParameter.FOLLOW_LINKS));
        this.validateOnly = (Boolean)this.getArg(RestfulRequest.RequestParameter.VALIDATE_ONLY);
    }

    private void ensureDomainModelQueryParamSupported() {
        RestfulRequest.DomainModel domainModel = (RestfulRequest.DomainModel)this.getArg(RestfulRequest.RequestParameter.DOMAIN_MODEL);
        if (domainModel != RestfulRequest.DomainModel.FORMAL) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (String)"x-ro-domain-model of '%s' is not supported", (Object[])new Object[]{domainModel});
        }
    }

    public String getUrlUnencodedQueryString() {
        return this.urlUnencodedQueryString;
    }

    public JsonRepresentation getQueryStringAsJsonRepr() {
        return this.readQueryStringAsMap;
    }

    protected JsonRepresentation requestArgsAsMap(Map<String, String[]> params) {
        if (ResourceContext.simpleQueryArgs(params)) {
            JsonRepresentation map = JsonRepresentation.newMap((String[])new String[0]);
            for (String paramName : params.keySet()) {
                String paramValue = params.get(paramName)[0];
                Object key = paramName.startsWith("x-ro") ? paramName : paramName + ".value";
                OptionalInt parseResult = _Ints.parseInt((String)paramValue, (int)10);
                if (parseResult.isPresent()) {
                    map.mapPut((String)key, parseResult.getAsInt());
                    continue;
                }
                map.mapPut((String)key, ResourceContext.stripQuotes(paramValue));
            }
            return map;
        }
        String queryString = this.getUrlUnencodedQueryString();
        return Util.readQueryStringAsMap((String)queryString);
    }

    static String stripQuotes(String str) {
        if (_Strings.isNullOrEmpty((CharSequence)str)) {
            return str;
        }
        if (str.startsWith("\"") && str.endsWith("\"")) {
            return str.substring(1, str.lastIndexOf("\""));
        }
        return str;
    }

    private static boolean simpleQueryArgs(Map<String, String[]> params) {
        if (params == null || params.isEmpty()) {
            return false;
        }
        for (String paramName : params.keySet()) {
            if (!"x-isis-querystring".equals(paramName) && !paramName.startsWith("{")) continue;
            return false;
        }
        return true;
    }

    public <Q> Q getArg(RestfulRequest.RequestParameter<Q> requestParameter) {
        JsonRepresentation queryStringJsonRepr = this.getQueryStringAsJsonRepr();
        return (Q)requestParameter.valueOf(queryStringJsonRepr);
    }

    public Where getWhere() {
        return this.where;
    }

    public RepresentationService.Intent getIntent() {
        return this.intent;
    }

    public SerializationStrategy getSerializationStrategy() {
        return SerializationStrategy.determineFrom(this.getAcceptableMediaTypes());
    }

    public boolean canEagerlyRender(ManagedObject objectAdapter) {
        return ManagedObjects.bookmark((ManagedObject)objectAdapter).map(this.rendered::add).orElse(true);
    }

    public boolean honorUiHints() {
        return this.getMetaModelContext().getConfiguration().getViewer().getRestfulobjects().isHonorUiHints();
    }

    public boolean objectPropertyValuesOnly() {
        return this.getMetaModelContext().getConfiguration().getViewer().getRestfulobjects().isObjectPropertyValuesOnly();
    }

    public boolean suppressDescribedByLinks() {
        return this.getMetaModelContext().getConfiguration().getViewer().getRestfulobjects().isSuppressDescribedByLinks();
    }

    public boolean suppressUpdateLink() {
        return this.getMetaModelContext().getConfiguration().getViewer().getRestfulobjects().isSuppressUpdateLink();
    }

    public boolean suppressMemberId() {
        return this.getMetaModelContext().getConfiguration().getViewer().getRestfulobjects().isSuppressMemberId();
    }

    public boolean suppressMemberLinks() {
        return this.getMetaModelContext().getConfiguration().getViewer().getRestfulobjects().isSuppressMemberLinks();
    }

    public boolean suppressMemberExtensions() {
        return this.getMetaModelContext().getConfiguration().getViewer().getRestfulobjects().isSuppressMemberExtensions();
    }

    public boolean suppressMemberDisabledReason() {
        return this.getMetaModelContext().getConfiguration().getViewer().getRestfulobjects().isSuppressMemberDisabledReason();
    }

    public String restfulUrlFor(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return this.restfulAbsoluteBase + url;
    }

    public String applicationUrlFor(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return this.applicationAbsoluteBase + (url.startsWith("/") ? url.substring(1) : url);
    }

    public List<MediaType> getAcceptableMediaTypes() {
        return this.httpHeaders.getAcceptableMediaTypes();
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public Request getRequest() {
        return this.request;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.httpServletResponse;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public List<List<String>> getFollowLinks() {
        return this.followLinks;
    }

    public boolean isValidateOnly() {
        return this.validateOnly;
    }

    public InteractionInitiatedBy getInteractionInitiatedBy() {
        return this.interactionInitiatedBy;
    }

    public ObjectAdapterLinkTo getObjectAdapterLinkTo() {
        return this.objectAdapterLinkTo;
    }

    public void setObjectAdapterLinkTo(ObjectAdapterLinkTo objectAdapterLinkTo) {
        this.objectAdapterLinkTo = objectAdapterLinkTo;
    }
}

