/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.viewer.resources;

import java.io.InputStream;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.services.iactnlayer.InteractionLayerTracker;
import org.apache.isis.commons.internal.codec._UrlDecoderUtil;
import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.domainservice.DomainServiceFacet;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.DomainServiceResource;
import org.apache.isis.viewer.restfulobjects.rendering.Caching;
import org.apache.isis.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.Responses;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainServiceLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAdapterLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.viewer.context.ResourceContext;
import org.apache.isis.viewer.restfulobjects.viewer.resources.DomainServicesListReprRenderer;
import org.apache.isis.viewer.restfulobjects.viewer.resources.ResourceAbstract;
import org.apache.isis.viewer.restfulobjects.viewer.resources.ResourceDescriptor;
import org.apache.isis.viewer.restfulobjects.viewer.resources._DomainResourceHelper;
import org.apache.isis.viewer.restfulobjects.viewer.resources._EndpointLogging;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
@Path(value="/services")
public class DomainServiceResourceServerside
extends ResourceAbstract
implements DomainServiceResource {
    private static final Logger log = LogManager.getLogger(DomainServiceResourceServerside.class);
    private static final Predicate<ManagedObject> NATURE_REST = input -> DomainServiceFacet.isContributing((FacetHolder)input.getSpecification());

    @Inject
    public DomainServiceResourceServerside(MetaModelContext metaModelContext, IsisConfiguration isisConfiguration, InteractionLayerTracker iInteractionLayerTracker) {
        super(metaModelContext, isisConfiguration, iInteractionLayerTracker);
        log.debug("<init>");
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/list\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response services() {
        ResourceContext resourceContext = this.createResourceContext(RepresentationType.LIST, Where.STANDALONE_TABLES, RepresentationService.Intent.NOT_APPLICABLE);
        MetaModelContext metaModelContext = resourceContext.getMetaModelContext();
        Stream<ManagedObject> serviceAdapters = metaModelContext.streamServiceAdapters().filter(NATURE_REST);
        DomainServicesListReprRenderer renderer = new DomainServicesListReprRenderer(resourceContext, null, JsonRepresentation.newMap((String[])new String[0]));
        renderer.usingLinkToBuilder((ObjectAdapterLinkTo)new DomainServiceLinkTo()).includesSelf().with(serviceAdapters);
        return _EndpointLogging.response(log, "GET /services/", Responses.ofOk((ReprRenderer)renderer, (Caching)Caching.ONE_DAY).build());
    }

    public Response deleteServicesNotAllowed() {
        throw _EndpointLogging.error(log, "DELETE /services", RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting the services resource is not allowed.", (Object[])new Object[0]));
    }

    public Response putServicesNotAllowed() {
        throw _EndpointLogging.error(log, "PUT /services", RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Putting to the services resource is not allowed.", (Object[])new Object[0]));
    }

    public Response postServicesNotAllowed() {
        throw _EndpointLogging.error(log, "POST /services", RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Posting to the services resource is not allowed.", (Object[])new Object[0]));
    }

    @GET
    @Path(value="/{serviceId}")
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/object\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/object\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response service(@PathParam(value="serviceId") String serviceId) {
        ResourceContext resourceContext = this.createResourceContext(RepresentationType.DOMAIN_OBJECT, Where.OBJECT_FORMS, RepresentationService.Intent.ALREADY_PERSISTENT);
        ManagedObject serviceAdapter = this.getServiceAdapter(serviceId);
        DomainObjectReprRenderer renderer = new DomainObjectReprRenderer((IResourceContext)resourceContext, null, JsonRepresentation.newMap((String[])new String[0]));
        renderer.usingLinkToBuilder((ObjectAdapterLinkTo)new DomainServiceLinkTo()).with(serviceAdapter).includesSelf();
        return _EndpointLogging.response(log, "GET /services/{}", serviceId, Responses.ofOk((ReprRenderer)renderer, (Caching)Caching.ONE_DAY).build());
    }

    @DELETE
    @Path(value="/{serviceId}")
    public Response deleteServiceNotAllowed(@PathParam(value="serviceId") String serviceId) {
        throw _EndpointLogging.error(log, "DELETE /services/{}", serviceId, RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting a service resource is not allowed.", (Object[])new Object[0]));
    }

    @PUT
    @Path(value="/{serviceId}")
    public Response putServiceNotAllowed(@PathParam(value="serviceId") String serviceId) {
        throw _EndpointLogging.error(log, "PUT /services/{}", serviceId, RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Putting to a service resource is not allowed.", (Object[])new Object[0]));
    }

    @POST
    @Path(value="/{serviceId}")
    public Response postServiceNotAllowed(@PathParam(value="serviceId") String serviceId) {
        throw _EndpointLogging.error(log, "POST /services/{}", serviceId, RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Posting to a service resource is not allowed.", (Object[])new Object[0]));
    }

    @GET
    @Path(value="/{serviceId}/actions/{actionId}")
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/object-action\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/object-action\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response actionPrompt(@PathParam(value="serviceId") String serviceId, @PathParam(value="actionId") String actionId) {
        ResourceContext resourceContext = this.createResourceContext(RepresentationType.OBJECT_ACTION, Where.OBJECT_FORMS, RepresentationService.Intent.ALREADY_PERSISTENT);
        ManagedObject serviceAdapter = this.getServiceAdapter(serviceId);
        _DomainResourceHelper domainResourceHelper = _DomainResourceHelper.ofServiceResource(resourceContext, serviceAdapter);
        return _EndpointLogging.response(log, "GET /services/{}/actions/{}", serviceId, actionId, domainResourceHelper.actionPrompt(actionId));
    }

    @DELETE
    @Path(value="/{serviceId}/actions/{actionId}")
    public Response deleteActionPromptNotAllowed(@PathParam(value="serviceId") String serviceId, @PathParam(value="actionId") String actionId) {
        throw _EndpointLogging.error(log, "DELETE /services/{}/actions/{}", serviceId, actionId, RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting action prompt resource is not allowed.", (Object[])new Object[0]));
    }

    @PUT
    @Path(value="/{serviceId}/actions/{actionId}")
    public Response putActionPromptNotAllowed(@PathParam(value="serviceId") String serviceId, @PathParam(value="actionId") String actionId) {
        throw _EndpointLogging.error(log, "PUT /services/{}/actions/{}", serviceId, actionId, RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Putting to an action prompt resource is not allowed.", (Object[])new Object[0]));
    }

    @POST
    @Path(value="/{serviceId}/actions/{actionId}")
    public Response postActionPromptNotAllowed(@PathParam(value="serviceId") String serviceId, @PathParam(value="actionId") String actionId) {
        throw _EndpointLogging.error(log, "POST /services/{}/actions/{}", serviceId, actionId, RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Posting to an action prompt resource is not allowed.", (Object[])new Object[0]));
    }

    @GET
    @Path(value="/{serviceId}/actions/{actionId}/invoke")
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response invokeActionQueryOnly(@PathParam(value="serviceId") String serviceId, @PathParam(value="actionId") String actionId, @QueryParam(value="x-isis-querystring") String xIsisUrlEncodedQueryString) {
        String urlUnencodedQueryString = _UrlDecoderUtil.urlDecodeNullSafe((String)(xIsisUrlEncodedQueryString != null ? xIsisUrlEncodedQueryString : this.httpServletRequest.getQueryString()));
        ResourceContext resourceContext = this.createResourceContext(ResourceDescriptor.of(RepresentationType.ACTION_RESULT, Where.STANDALONE_TABLES, RepresentationService.Intent.NOT_APPLICABLE), urlUnencodedQueryString);
        JsonRepresentation arguments = resourceContext.getQueryStringAsJsonRepr();
        ManagedObject serviceAdapter = this.getServiceAdapter(serviceId);
        _DomainResourceHelper domainResourceHelper = _DomainResourceHelper.ofServiceResource(resourceContext, serviceAdapter);
        return _EndpointLogging.response(log, "GET /services/{}/actions/{}/invoke", serviceId, actionId, domainResourceHelper.invokeActionQueryOnly(actionId, arguments));
    }

    @PUT
    @Path(value="/{serviceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response invokeActionIdempotent(@PathParam(value="serviceId") String serviceId, @PathParam(value="actionId") String actionId, InputStream body) {
        ResourceContext resourceContext = this.createResourceContext(ResourceDescriptor.of(RepresentationType.ACTION_RESULT, Where.STANDALONE_TABLES, RepresentationService.Intent.NOT_APPLICABLE), body);
        JsonRepresentation arguments = resourceContext.getQueryStringAsJsonRepr();
        ManagedObject serviceAdapter = this.getServiceAdapter(serviceId);
        _DomainResourceHelper domainResourceHelper = _DomainResourceHelper.ofServiceResource(resourceContext, serviceAdapter);
        return _EndpointLogging.response(log, "PUT /services/{}/actions/{}/invoke", serviceId, actionId, domainResourceHelper.invokeActionIdempotent(actionId, arguments));
    }

    @POST
    @Path(value="/{serviceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/action-result\"", "application/xml;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response invokeAction(@PathParam(value="serviceId") String serviceId, @PathParam(value="actionId") String actionId, InputStream body) {
        ResourceContext resourceContext = this.createResourceContext(ResourceDescriptor.of(RepresentationType.ACTION_RESULT, Where.STANDALONE_TABLES, RepresentationService.Intent.NOT_APPLICABLE), body);
        JsonRepresentation arguments = resourceContext.getQueryStringAsJsonRepr();
        ManagedObject serviceAdapter = this.getServiceAdapter(serviceId);
        _DomainResourceHelper domainResourceHelper = _DomainResourceHelper.ofServiceResource(resourceContext, serviceAdapter);
        return _EndpointLogging.response(log, "POST /services/{}/actions/{}/invoke", serviceId, actionId, domainResourceHelper.invokeAction(actionId, arguments));
    }

    @DELETE
    @Path(value="/{serviceId}/actions/{actionId}/invoke")
    public Response deleteInvokeActionNotAllowed(@PathParam(value="serviceId") String serviceId, @PathParam(value="actionId") String actionId) {
        throw _EndpointLogging.error(log, "DELETE /services/{}/actions/{}/invoke", serviceId, actionId, RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting an action invocation resource is not allowed.", (Object[])new Object[0]));
    }
}

