/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.viewer.resources;

import java.util.function.UnaryOperator;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.services.iactnlayer.InteractionLayerTracker;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.facets.object.grid.GridFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.domaintypes.DomainTypeResource;
import org.apache.isis.viewer.restfulobjects.applib.util.UrlEncodingUtils;
import org.apache.isis.viewer.restfulobjects.rendering.Caching;
import org.apache.isis.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.Responses;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.ActionDescriptionReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.ActionParameterDescriptionReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.CollectionDescriptionReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.DomainTypeReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.ParentSpecAndAction;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.ParentSpecAndActionParam;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.ParentSpecAndCollection;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.ParentSpecAndFeature;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.ParentSpecAndProperty;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.PropertyDescriptionReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.TypeActionResultReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.TypeListReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.rendering.util.Util;
import org.apache.isis.viewer.restfulobjects.viewer.context.ResourceContext;
import org.apache.isis.viewer.restfulobjects.viewer.resources.ResourceAbstract;
import org.apache.isis.viewer.restfulobjects.viewer.resources.ResourceDescriptor;
import org.apache.isis.viewer.restfulobjects.viewer.resources._EndpointLogging;
import org.apache.isis.viewer.restfulobjects.viewer.resources.serialization.SerializationStrategy;
import org.apache.isis.viewer.restfulobjects.viewer.util.UrlParserUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
@Path(value="/domain-types")
public class DomainTypeResourceServerside
extends ResourceAbstract
implements DomainTypeResource {
    private static final Logger log = LogManager.getLogger(DomainTypeResourceServerside.class);

    @Inject
    public DomainTypeResourceServerside(MetaModelContext metaModelContext, IsisConfiguration isisConfiguration, InteractionLayerTracker iInteractionLayerTracker) {
        super(metaModelContext, isisConfiguration, iInteractionLayerTracker);
        log.debug("<init>");
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/type-list\""})
    public Response domainTypes() {
        ResourceContext resourceContext = this.createResourceContext(RepresentationType.TYPE_LIST, Where.ANYWHERE, RepresentationService.Intent.NOT_APPLICABLE);
        Can domainTypeSpecifications = this.getSpecificationLoader().snapshotSpecifications().filter(spec -> spec.isEntityOrViewModel());
        TypeListReprRenderer renderer = new TypeListReprRenderer((IResourceContext)resourceContext, null, JsonRepresentation.newMap((String[])new String[0]));
        renderer.with(domainTypeSpecifications).includesSelf();
        return _EndpointLogging.response(log, "GET /domain-types/", Responses.ofOk((ReprRenderer)renderer, (Caching)Caching.ONE_DAY).build());
    }

    @GET
    @Path(value="/{domainType}")
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/domain-type\""})
    public Response domainType(@PathParam(value="domainType") String domainType) {
        ResourceContext resourceContext = this.createResourceContext(RepresentationType.DOMAIN_TYPE, Where.ANYWHERE, RepresentationService.Intent.NOT_APPLICABLE);
        ObjectSpecification objectSpec = this.getSpecificationLoader().specForLogicalTypeName(domainType).orElse(null);
        if (objectSpec == null) {
            throw _EndpointLogging.error(log, "GET /domain-types/{}", domainType, RestfulObjectsApplicationException.create((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_FOUND));
        }
        DomainTypeReprRenderer renderer = new DomainTypeReprRenderer((IResourceContext)resourceContext, null, JsonRepresentation.newMap((String[])new String[0]));
        renderer.with(objectSpec).includesSelf();
        return _EndpointLogging.response(log, "GET /domain-types/{}", domainType, Responses.ofOk((ReprRenderer)renderer, (Caching)Caching.ONE_DAY).build());
    }

    @GET
    @Path(value="/{domainType}/layout")
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/layout-bs3\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/layout-bs3\""})
    public Response layout(@PathParam(value="domainType") String domainType) {
        ResourceContext resourceContext = this.createResourceContext(RepresentationType.LAYOUT, Where.ANYWHERE, RepresentationService.Intent.NOT_APPLICABLE);
        SerializationStrategy serializationStrategy = resourceContext.getSerializationStrategy();
        Response.ResponseBuilder responseBuilder = this.getSpecificationLoader().specForLogicalTypeName(domainType).map(spec -> (GridFacet)spec.getFacet(GridFacet.class)).map(gridFacet -> gridFacet.getGrid(null)).map(grid -> Response.status((Response.Status)Response.Status.OK).entity(serializationStrategy.entity(grid)).type(serializationStrategy.type(RepresentationType.LAYOUT))).orElse(Responses.ofNotFound());
        return _EndpointLogging.response(log, "GET({}) /domain-types/{}/layout", serializationStrategy.name(), domainType, responseBuilder.build());
    }

    @GET
    @Path(value="/{domainType}/properties/{propertyId}")
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/property-description\""})
    public Response typeProperty(@PathParam(value="domainType") String domainType, @PathParam(value="propertyId") String propertyId) {
        ResourceContext resourceContext = this.createResourceContext(RepresentationType.PROPERTY_DESCRIPTION, Where.ANYWHERE, RepresentationService.Intent.NOT_APPLICABLE);
        ObjectSpecification parentSpec = this.getSpecificationLoader().specForLogicalTypeName(domainType).orElse(null);
        if (parentSpec == null) {
            throw _EndpointLogging.error(log, "GET /domain-types/{}/properties/{}", domainType, propertyId, RestfulObjectsApplicationException.create((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_FOUND));
        }
        ObjectAssociation objectMember = (ObjectAssociation)parentSpec.getAssociation(propertyId).orElseThrow(() -> _EndpointLogging.error(log, "GET /domain-types/{}/properties/{}", domainType, propertyId, RestfulObjectsApplicationException.create((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_FOUND)));
        if (objectMember.isOneToManyAssociation()) {
            throw _EndpointLogging.error(log, "GET /domain-types/{}/properties/{}", domainType, propertyId, RestfulObjectsApplicationException.create((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_FOUND));
        }
        OneToOneAssociation property = (OneToOneAssociation)objectMember;
        PropertyDescriptionReprRenderer renderer = new PropertyDescriptionReprRenderer((IResourceContext)resourceContext, null, JsonRepresentation.newMap((String[])new String[0]));
        renderer.with((ParentSpecAndFeature)new ParentSpecAndProperty(parentSpec, property)).includesSelf();
        return _EndpointLogging.response(log, "GET /domain-types/{}/properties/{}", domainType, propertyId, Responses.ofOk((ReprRenderer)renderer, (Caching)Caching.ONE_DAY).build());
    }

    @GET
    @Path(value="/{domainType}/collections/{collectionId}")
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/collection-description\""})
    public Response typeCollection(@PathParam(value="domainType") String domainType, @PathParam(value="collectionId") String collectionId) {
        ResourceContext resourceContext = this.createResourceContext(RepresentationType.COLLECTION_DESCRIPTION, Where.ANYWHERE, RepresentationService.Intent.NOT_APPLICABLE);
        ObjectSpecification parentSpec = this.getSpecificationLoader().specForLogicalTypeName(domainType).orElse(null);
        if (parentSpec == null) {
            throw _EndpointLogging.error(log, "GET /domain-types/{}/collections/{}", domainType, collectionId, RestfulObjectsApplicationException.create((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_FOUND));
        }
        ObjectAssociation objectMember = (ObjectAssociation)parentSpec.getAssociation(collectionId).orElseThrow(() -> _EndpointLogging.error(log, "GET /domain-types/{}/collections/{}", domainType, collectionId, RestfulObjectsApplicationException.create((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_FOUND)));
        if (objectMember.isOneToOneAssociation()) {
            throw _EndpointLogging.error(log, "GET /domain-types/{}/collections/{}", domainType, collectionId, RestfulObjectsApplicationException.create((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_FOUND));
        }
        OneToManyAssociation collection = (OneToManyAssociation)objectMember;
        CollectionDescriptionReprRenderer renderer = new CollectionDescriptionReprRenderer((IResourceContext)resourceContext, null, JsonRepresentation.newMap((String[])new String[0]));
        renderer.with((ParentSpecAndFeature)new ParentSpecAndCollection(parentSpec, collection)).includesSelf();
        return _EndpointLogging.response(log, "GET /domain-types/{}/collections/{}", domainType, collectionId, Responses.ofOk((ReprRenderer)renderer, (Caching)Caching.ONE_DAY).build());
    }

    @GET
    @Path(value="/{domainType}/actions/{actionId}")
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/action-description\""})
    public Response typeAction(@PathParam(value="domainType") String domainType, @PathParam(value="actionId") String actionId) {
        ResourceContext resourceContext = this.createResourceContext(RepresentationType.ACTION_DESCRIPTION, Where.ANYWHERE, RepresentationService.Intent.NOT_APPLICABLE);
        ObjectSpecification parentSpec = this.getSpecificationLoader().specForLogicalTypeName(domainType).orElse(null);
        if (parentSpec == null) {
            throw _EndpointLogging.error(log, "GET /domain-types/{}/actions/{}", domainType, actionId, RestfulObjectsApplicationException.create((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_FOUND));
        }
        ObjectAction action = (ObjectAction)parentSpec.getAction(actionId).orElseThrow(() -> _EndpointLogging.error(log, "GET /domain-types/{}/actions/{}", domainType, actionId, RestfulObjectsApplicationException.create((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_FOUND)));
        ActionDescriptionReprRenderer renderer = new ActionDescriptionReprRenderer((IResourceContext)resourceContext, null, JsonRepresentation.newMap((String[])new String[0]));
        renderer.with((ParentSpecAndFeature)new ParentSpecAndAction(parentSpec, action)).includesSelf();
        return _EndpointLogging.response(log, "GET /domain-types/{}/actions/{}", domainType, actionId, Responses.ofOk((ReprRenderer)renderer, (Caching)Caching.ONE_DAY).build());
    }

    @GET
    @Path(value="/{domainType}/actions/{actionId}/params/{paramName}")
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/action-param-description\""})
    public Response typeActionParam(@PathParam(value="domainType") String domainType, @PathParam(value="actionId") String actionId, @PathParam(value="paramName") String paramName) {
        ResourceContext resourceContext = this.createResourceContext(RepresentationType.ACTION_PARAMETER_DESCRIPTION, Where.ANYWHERE, RepresentationService.Intent.NOT_APPLICABLE);
        ObjectSpecification parentSpec = this.getSpecificationLoader().specForLogicalTypeName(domainType).orElse(null);
        if (parentSpec == null) {
            throw _EndpointLogging.error(log, "GET /domain-types/{}/actions/{}/params/{}", domainType, actionId, paramName, RestfulObjectsApplicationException.create((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_FOUND));
        }
        ObjectAction parentAction = (ObjectAction)parentSpec.getAction(actionId).orElseThrow(() -> _EndpointLogging.error(log, "GET /domain-types/{}/actions/{}/params/{}", domainType, actionId, paramName, RestfulObjectsApplicationException.create((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_FOUND)));
        ObjectActionParameter actionParam = parentAction.getParameterByName(paramName);
        ActionParameterDescriptionReprRenderer renderer = new ActionParameterDescriptionReprRenderer((IResourceContext)resourceContext, null, JsonRepresentation.newMap((String[])new String[0]));
        renderer.with((ParentSpecAndFeature)new ParentSpecAndActionParam(parentSpec, actionParam)).includesSelf();
        return _EndpointLogging.response(log, "GET /domain-types/{}/actions/{}/params/{}", domainType, actionId, paramName, Responses.ofOk((ReprRenderer)renderer, (Caching)Caching.ONE_DAY).build());
    }

    @GET
    @Path(value="/{domainType}/type-actions/isSubtypeOf/invoke")
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/type-action-result\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response domainTypeIsSubtypeOf(@PathParam(value="domainType") String domainType, @QueryParam(value="supertype") String superTypeStr, @QueryParam(value="args") String argsUrlEncoded) {
        ResourceContext resourceContext = this.createResourceContext(ResourceDescriptor.generic(Where.ANYWHERE, RepresentationService.Intent.NOT_APPLICABLE));
        String supertype = DomainTypeResourceServerside.domainTypeFor(superTypeStr, argsUrlEncoded, "supertype", roEx -> _EndpointLogging.error(log, "GET /domain-types/{}/type-actions/isSubtypeOf/invoke", domainType, roEx));
        ObjectSpecification domainTypeSpec = this.getSpecificationLoader().specForLogicalTypeName(domainType).orElse(null);
        ObjectSpecification supertypeSpec = this.getSpecificationLoader().specForLogicalTypeName(supertype).orElse(null);
        if (domainTypeSpec == null || supertypeSpec == null) {
            throw _EndpointLogging.error(log, "GET /domain-types/{}/type-actions/isSubtypeOf/invoke", domainType, RestfulObjectsApplicationException.create((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_FOUND));
        }
        TypeActionResultReprRenderer renderer = new TypeActionResultReprRenderer((IResourceContext)resourceContext, null, JsonRepresentation.newMap((String[])new String[0]));
        String url = "domain-types/" + domainType + "/type-actions/isSubtypeOf/invoke";
        LinkBuilder linkBuilder = LinkBuilder.newBuilder((IResourceContext)resourceContext, (String)Rel.SELF.getName(), (RepresentationType)RepresentationType.TYPE_ACTION_RESULT, (String)url, (Object[])new Object[0]);
        JsonRepresentation arguments = DomainTypeReprRenderer.argumentsTo((IResourceContext)resourceContext, (String)"supertype", (ObjectSpecification)supertypeSpec);
        JsonRepresentation selfLink = linkBuilder.withArguments(arguments).build();
        boolean value = domainTypeSpec.isOfType(supertypeSpec);
        renderer.with(domainTypeSpec).withSelf(selfLink).withValue((Object)value);
        return _EndpointLogging.response(log, "GET /domain-types/{}/type-actions/isSubtypeOf/invoke", domainType, Responses.ofOk((ReprRenderer)renderer, (Caching)Caching.ONE_DAY).build());
    }

    @GET
    @Path(value="/{domainType}/type-actions/isSupertypeOf/invoke")
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/type-action-result\"", "application/json;profile=\"urn:org.restfulobjects:repr-types/error\""})
    public Response domainTypeIsSupertypeOf(@PathParam(value="domainType") String domainType, @QueryParam(value="subtype") String subTypeStr, @QueryParam(value="args") String argsUrlEncoded) {
        ResourceContext resourceContext = this.createResourceContext(ResourceDescriptor.generic(Where.ANYWHERE, RepresentationService.Intent.NOT_APPLICABLE));
        String subtype = DomainTypeResourceServerside.domainTypeFor(subTypeStr, argsUrlEncoded, "subtype", roEx -> _EndpointLogging.error(log, "GET /domain-types/{}/type-actions/isSupertypeOf/invoke", domainType, roEx));
        ObjectSpecification domainTypeSpec = this.getSpecificationLoader().specForLogicalTypeName(domainType).orElse(null);
        ObjectSpecification subtypeSpec = this.getSpecificationLoader().specForLogicalTypeName(subtype).orElse(null);
        if (domainTypeSpec == null || subtypeSpec == null) {
            throw _EndpointLogging.error(log, "GET /domain-types/{}/type-actions/isSupertypeOf/invoke", domainType, RestfulObjectsApplicationException.create((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_FOUND));
        }
        TypeActionResultReprRenderer renderer = new TypeActionResultReprRenderer((IResourceContext)resourceContext, null, JsonRepresentation.newMap((String[])new String[0]));
        String url = "domain-types/" + domainType + "/type-actions/isSupertypeOf/invoke";
        LinkBuilder linkBuilder = LinkBuilder.newBuilder((IResourceContext)resourceContext, (String)Rel.SELF.getName(), (RepresentationType)RepresentationType.TYPE_ACTION_RESULT, (String)url, (Object[])new Object[0]);
        JsonRepresentation arguments = DomainTypeReprRenderer.argumentsTo((IResourceContext)resourceContext, (String)"subtype", (ObjectSpecification)subtypeSpec);
        JsonRepresentation selfLink = linkBuilder.withArguments(arguments).build();
        boolean value = subtypeSpec.isOfType(domainTypeSpec);
        renderer.with(domainTypeSpec).withSelf(selfLink).withValue((Object)value);
        return _EndpointLogging.response(log, "GET /domain-types/{}/type-actions/isSupertypeOf/invoke", domainType, Responses.ofOk((ReprRenderer)renderer, (Caching)Caching.ONE_DAY).build());
    }

    private static String domainTypeFor(String domainTypeStr, String argsAsUrlEncodedQueryString, String argsParamName, @NonNull UnaryOperator<RestfulObjectsApplicationException> onRoException) {
        if (onRoException == null) {
            throw new NullPointerException("onRoException is marked non-null but is null");
        }
        if (!_Strings.isNullOrEmpty((CharSequence)domainTypeStr)) {
            return domainTypeStr;
        }
        String argsAsQueryString = UrlEncodingUtils.urlDecode((String)argsAsUrlEncodedQueryString);
        String href = DomainTypeResourceServerside.linkFromFormalArgs(argsAsQueryString, argsParamName, onRoException);
        return UrlParserUtils.domainTypeFrom(href);
    }

    private static String linkFromFormalArgs(String argumentsAsQueryString, String paramName, @NonNull UnaryOperator<RestfulObjectsApplicationException> onRoException) {
        if (onRoException == null) {
            throw new NullPointerException("onRoException is marked non-null but is null");
        }
        JsonRepresentation arguments = Util.readQueryStringAsMap((String)argumentsAsQueryString);
        if (!arguments.isLink(paramName)) {
            throw (RestfulObjectsApplicationException)onRoException.apply(RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (String)"Args should contain a link '%s'", (Object[])new Object[]{paramName}));
        }
        return arguments.getLink(paramName).getHref();
    }
}

