/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.viewer.resources;

import lombok.NonNull;
import org.apache.isis.core.metamodel.interactions.managed.InteractionVeto;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.springframework.lang.Nullable;

public class InteractionFailureHandler {
    public static RestfulObjectsApplicationException onFailure(@Nullable InteractionVeto veto) {
        if (veto == null) {
            return RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.INTERNAL_SERVER_ERROR, (String)"unexpected empty failure holder", (Object[])new Object[0]);
        }
        switch (veto.getVetoType()) {
            case NOT_FOUND: 
            case HIDDEN: {
                return RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_FOUND, (String)veto.getReason(), (Object[])new Object[0]);
            }
            case READONLY: 
            case INVALID: {
                return RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.FORBIDDEN, (String)veto.getReason(), (Object[])new Object[0]);
            }
            case ACTION_NOT_SAFE: 
            case ACTION_NOT_IDEMPOTENT: {
                return RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)veto.getReason(), (Object[])new Object[0]);
            }
            case ACTION_PARAM_INVALID: {
                return RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.VALIDATION_FAILED, (String)veto.getReason(), (Object[])new Object[0]);
            }
        }
        return RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.INTERNAL_SERVER_ERROR, (String)("unmatched veto type " + veto.getVetoType()), (Object[])new Object[0]);
    }

    public static RestfulObjectsApplicationException onParameterListInvalid(@NonNull InteractionVeto veto, @NonNull JsonRepresentation arguments) {
        if (veto == null) {
            throw new NullPointerException("veto is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        if (veto != null) {
            arguments.mapPut("x-ro-invalidReason", veto.getReason());
        }
        return RestfulObjectsApplicationException.createWithBody((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.VALIDATION_FAILED, (JsonRepresentation)arguments, (String)"Validation failed, see body for details", (Object[])new Object[0]);
    }

    public static void collectParameterInvalid(@NonNull ObjectActionParameter paramMeta, @NonNull InteractionVeto veto, @NonNull JsonRepresentation arguments) {
        if (paramMeta == null) {
            throw new NullPointerException("paramMeta is marked non-null but is null");
        }
        if (veto == null) {
            throw new NullPointerException("veto is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        String paramId = paramMeta.getId();
        JsonRepresentation argRepr = arguments.getRepresentation(paramId, new Object[0]);
        argRepr.mapPut("invalidReason", veto.getReason());
    }
}

