/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.viewer.resources;

import java.util.function.Consumer;
import javax.inject.Inject;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.layout.component.ServiceActionLayoutData;
import org.apache.isis.applib.layout.links.Link;
import org.apache.isis.applib.layout.menubars.MenuBars;
import org.apache.isis.applib.services.iactnlayer.InteractionLayerTracker;
import org.apache.isis.applib.services.menu.MenuBarsService;
import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.menubars.MenuBarsResource;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.viewer.context.ResourceContext;
import org.apache.isis.viewer.restfulobjects.viewer.resources.ResourceAbstract;
import org.apache.isis.viewer.restfulobjects.viewer.resources.serialization.SerializationStrategy;
import org.springframework.stereotype.Component;

@Component
public class MenuBarsResourceServerside
extends ResourceAbstract
implements MenuBarsResource {
    public static final String SERVICE_IDENTIFIER = "1";

    @Inject
    public MenuBarsResourceServerside(MetaModelContext metaModelContext, IsisConfiguration isisConfiguration, InteractionLayerTracker iInteractionLayerTracker) {
        super(metaModelContext, isisConfiguration, iInteractionLayerTracker);
    }

    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/layout-menubars\"", "application/xml", "application/xml;profile=\"urn:org.restfulobjects:repr-types/layout-menubars\""})
    public Response menuBars() {
        ResourceContext resourceContext = this.createResourceContext(RepresentationType.MENUBARS, Where.ANYWHERE, RepresentationService.Intent.NOT_APPLICABLE);
        SerializationStrategy serializationStrategy = resourceContext.getSerializationStrategy();
        MenuBarsService menuBarsService = (MenuBarsService)this.metaModelContext.getServiceRegistry().lookupServiceElseFail(MenuBarsService.class);
        MenuBars menuBars = menuBarsService.menuBars();
        this.addLinksForServiceActions(resourceContext, menuBars);
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK).entity(serializationStrategy.entity(menuBars)).type(serializationStrategy.type(RepresentationType.MENUBARS));
        return builder.build();
    }

    void addLinksForServiceActions(ResourceContext resourceContext, MenuBars menuBars) {
        menuBars.visit(MenuBarsResourceServerside.linksForServiceActionsAddingVisitor(resourceContext));
    }

    public static Consumer<ServiceActionLayoutData> linksForServiceActionsAddingVisitor(ResourceContext resourceContext) {
        return actionLayoutData -> {
            String logicalTypeName = actionLayoutData.getLogicalTypeName();
            String relativeUrl = String.format("objects/%s/%s/actions/%s", logicalTypeName, SERVICE_IDENTIFIER, actionLayoutData.getId());
            Link link = new Link(Rel.ACTION.getName(), "GET", resourceContext.restfulUrlFor(relativeUrl), RepresentationType.OBJECT_ACTION.getJsonMediaType().toString());
            actionLayoutData.setLink(link);
        };
    }

    public Response deleteMenuBarsNotAllowed() {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting the menuBars resource is not allowed.", (Object[])new Object[0]);
    }

    public Response putMenuBarsNotAllowed() {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Putting to the menuBars resource is not allowed.", (Object[])new Object[0]);
    }

    public Response postMenuBarsNotAllowed() {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Posting to the menuBars resource is not allowed.", (Object[])new Object[0]);
    }
}

