/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.viewer.resources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.functional.Result;
import org.apache.isis.commons.internal.base._Either;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.interactions.managed.InteractionVeto;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.viewer.resources.JsonParserHelper;

public class ObjectActionArgHelper {
    public static Can<_Either<ManagedObject, InteractionVeto>> parseArguments(IResourceContext resourceContext, ObjectAction action, JsonRepresentation arguments) {
        List<JsonRepresentation> jsonArgList = ObjectActionArgHelper.argListFor(action, arguments);
        ArrayList argAdapters = _Lists.newArrayList();
        Can parameters = action.getParameters();
        int i = 0;
        while (i < jsonArgList.size()) {
            JsonRepresentation argRepr = jsonArgList.get(i);
            int argIndex = i++;
            ObjectActionParameter paramMeta = (ObjectActionParameter)parameters.getElseFail(argIndex);
            ObjectSpecification paramSpec = paramMeta.getElementType();
            _Either objectOrVeto = (_Either)Result.of(() -> paramMeta.isOptional() && argRepr == null ? ManagedObject.empty((ObjectSpecification)paramSpec) : new JsonParserHelper(resourceContext, paramSpec).objectAdapterFor(argRepr)).fold(_Either::left, exception -> _Either.right((Object)InteractionVeto.actionParamInvalid((String)String.format("exception when parsing paramNr %d [%s]: %s", argIndex, argRepr, exception))));
            argAdapters.add(objectOrVeto);
        }
        return Can.ofCollection((Collection)argAdapters);
    }

    private static List<JsonRepresentation> argListFor(ObjectAction action, JsonRepresentation arguments) {
        ArrayList argList = _Lists.newArrayList();
        arguments.streamMapEntries().map(Map.Entry::getKey).filter(argName -> !argName.startsWith("x-ro")).forEach(argName -> {
            if (action.getParameterById(argName) == null) {
                String reason = String.format("Argument '%s' found but no such parameter", argName);
                arguments.mapPut("x-ro-invalidReason", reason);
                throw RestfulObjectsApplicationException.createWithBody((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (JsonRepresentation)arguments, (String)reason, (Object[])new Object[0]);
            }
        });
        Can parameters = action.getParameters();
        for (ObjectActionParameter param : parameters) {
            String paramId = param.getId();
            JsonRepresentation argRepr = arguments.getRepresentation(paramId, new Object[0]);
            if (argRepr == null && !param.isOptional()) {
                String reason = String.format("No argument found for (mandatory) parameter '%s'", paramId);
                arguments.mapPut("x-ro-invalidReason", reason);
                throw RestfulObjectsApplicationException.createWithBody((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (JsonRepresentation)arguments, (String)reason, (Object[])new Object[0]);
            }
            argList.add(argRepr);
        }
        return argList;
    }

    private ObjectActionArgHelper() {
    }

    public static ObjectActionArgHelper of() {
        return new ObjectActionArgHelper();
    }
}

