/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.viewer.resources;

import java.io.InputStream;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import lombok.NonNull;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.iactnlayer.InteractionLayerTracker;
import org.apache.isis.commons.internal.base._Refs;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.codec._UrlDecoderUtil;
import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.core.config.viewer.web.WebAppContextPath;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.rendering.UrlDecoderUtils;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.rendering.util.Util;
import org.apache.isis.viewer.restfulobjects.viewer.context.ResourceContext;
import org.apache.isis.viewer.restfulobjects.viewer.resources.ResourceDescriptor;

public abstract class ResourceAbstract {
    protected final MetaModelContext metaModelContext;
    protected final IsisConfiguration isisConfiguration;
    protected final InteractionLayerTracker iInteractionLayerTracker;
    @Context
    HttpHeaders httpHeaders;
    @Context
    UriInfo uriInfo;
    @Context
    Request request;
    @Context
    HttpServletRequest httpServletRequest;
    @Context
    HttpServletResponse httpServletResponse;
    @Context
    SecurityContext securityContext;
    @Context
    Providers providers;
    @Inject
    WebAppContextPath webAppContextPath;

    @Inject
    protected ResourceAbstract(MetaModelContext metaModelContext, IsisConfiguration isisConfiguration, InteractionLayerTracker iInteractionLayerTracker) {
        this.metaModelContext = metaModelContext;
        this.isisConfiguration = isisConfiguration;
        this.iInteractionLayerTracker = iInteractionLayerTracker;
    }

    protected ResourceContext createResourceContext(RepresentationType representationType, Where where, RepresentationService.Intent intent) {
        return this.createResourceContext(ResourceDescriptor.of(representationType, where, intent));
    }

    protected ResourceContext createResourceContext(ResourceDescriptor resourceDescriptor) {
        String queryStringIfAny = this.getUrlDecodedQueryStringIfAny();
        return this.createResourceContext(resourceDescriptor, queryStringIfAny);
    }

    protected ResourceContext createResourceContext(ResourceDescriptor resourceDescriptor, InputStream arguments) {
        String urlDecodedQueryString = Util.asStringUtf8((InputStream)arguments);
        return this.createResourceContext(resourceDescriptor, urlDecodedQueryString);
    }

    protected ResourceContext createResourceContext(ResourceDescriptor resourceDescriptor, String urlUnencodedQueryString) {
        if (!this.iInteractionLayerTracker.isInInteraction()) {
            throw RestfulObjectsApplicationException.create((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.UNAUTHORIZED);
        }
        String restfulAbsoluteBase = this.isisConfiguration.getViewer().getRestfulobjects().getBaseUri().orElseGet(() -> this.uriInfo.getBaseUri().toString());
        String restfulRelativeBase = this.uriInfo.getBaseUri().getRawPath();
        String serverAbsoluteBase = _Strings.suffix((String)_Refs.stringRef((String)restfulAbsoluteBase).cutAtLastIndexOfAndDrop(restfulRelativeBase), (String)"/");
        String applicationAbsoluteBase = _Strings.suffix((String)this.webAppContextPath.appendContextPath(serverAbsoluteBase), (String)"/");
        return this.resourceContext(resourceDescriptor, applicationAbsoluteBase, restfulAbsoluteBase, urlUnencodedQueryString, this.httpServletRequest.getParameterMap());
    }

    public ResourceContext resourceContextForTesting(ResourceDescriptor resourceDescriptor, Map<String, String[]> requestParams) {
        return this.resourceContext(resourceDescriptor, "", "/restful", null, requestParams);
    }

    protected ManagedObject getObjectAdapterElseThrowNotFound(String domainType, String instanceIdEncoded, @NonNull UnaryOperator<RestfulObjectsApplicationException> onRoException) {
        if (onRoException == null) {
            throw new NullPointerException("onRoException is marked non-null but is null");
        }
        String instanceIdDecoded = UrlDecoderUtils.urlDecode((String)instanceIdEncoded);
        Bookmark bookmark = Bookmark.forLogicalTypeNameAndIdentifier((String)domainType, (String)instanceIdDecoded);
        return (ManagedObject)this.metaModelContext.loadObject(bookmark).orElseThrow(() -> (RestfulObjectsApplicationException)onRoException.apply(RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_FOUND, (String)"Could not determine adapter for bookmark: '%s'", (Object[])new Object[]{bookmark})));
    }

    protected ManagedObject getServiceAdapter(String serviceId) {
        ManagedObject serviceAdapter = this.metaModelContext.lookupServiceAdapterById(serviceId);
        if (serviceAdapter == null) {
            throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_FOUND, (String)"Could not locate service '%s'", (Object[])new Object[]{serviceId});
        }
        return serviceAdapter;
    }

    protected SpecificationLoader getSpecificationLoader() {
        return this.metaModelContext.getSpecificationLoader();
    }

    private String getUrlDecodedQueryStringIfAny() {
        String queryStringIfAny = this.httpServletRequest.getQueryString();
        return _UrlDecoderUtil.urlDecodeNullSafe((String)queryStringIfAny);
    }

    private ResourceContext resourceContext(ResourceDescriptor resourceDescriptor, String applicationAbsoluteBase, String restfulAbsoluteBase, String urlUnencodedQueryString, Map<String, String[]> requestParams) {
        return new ResourceContext(resourceDescriptor, this.httpHeaders, this.providers, this.request, applicationAbsoluteBase, restfulAbsoluteBase, urlUnencodedQueryString, this.httpServletRequest, this.httpServletResponse, this.securityContext, this.metaModelContext, InteractionInitiatedBy.USER, requestParams);
    }
}

