/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.viewer.resources;

import org.apache.isis.applib.services.iactnlayer.InteractionContext;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRendererAbstract;
import org.apache.isis.viewer.restfulobjects.viewer.resources.HomePageReprRenderer;

public class UserReprRenderer
extends ReprRendererAbstract<InteractionContext> {
    UserReprRenderer(IResourceContext resourceContext, LinkFollowSpecs linkFollower, JsonRepresentation representation) {
        super(resourceContext, linkFollower, RepresentationType.USER, representation);
    }

    public UserReprRenderer with(InteractionContext authentication) {
        this.representation.mapPut("userName", authentication.getUser().getName());
        JsonRepresentation roles = JsonRepresentation.newArray();
        authentication.getUser().streamRoleNames().forEach(arg_0 -> ((JsonRepresentation)roles).arrayAdd(arg_0));
        this.representation.mapPut("roles", roles);
        return this;
    }

    public JsonRepresentation render() {
        if (this.includesSelf) {
            this.addLinkToSelf();
            this.addLinkToUp();
            this.addLinkToLogout();
        }
        this.getExtensions();
        return this.representation;
    }

    private void addLinkToSelf() {
        JsonRepresentation link = LinkBuilder.newBuilder((IResourceContext)this.getResourceContext(), (String)Rel.SELF.getName(), (RepresentationType)RepresentationType.USER, (String)"user", (Object[])new Object[0]).build();
        LinkFollowSpecs linkFollower = this.getLinkFollowSpecs().follow("links", new Object[0]);
        if (linkFollower.matches(link)) {
            UserReprRenderer renderer = new UserReprRenderer(this.getResourceContext(), linkFollower, JsonRepresentation.newMap((String[])new String[0]));
            renderer.with(this.getResourceContext().getInteractionProvider().currentInteractionContextElseFail());
            link.mapPut("value", renderer.render());
        }
        this.getLinks().arrayAdd(link);
    }

    private void addLinkToUp() {
        JsonRepresentation link = LinkBuilder.newBuilder((IResourceContext)this.resourceContext, (String)Rel.UP.getName(), (RepresentationType)RepresentationType.HOME_PAGE, (String)"", (Object[])new Object[0]).build();
        LinkFollowSpecs linkFollower = this.getLinkFollowSpecs().follow("links", new Object[0]);
        if (linkFollower.matches(link)) {
            HomePageReprRenderer renderer = new HomePageReprRenderer(this.getResourceContext(), linkFollower, JsonRepresentation.newMap((String[])new String[0]));
            link.mapPut("value", renderer.render());
        }
        this.getLinks().arrayAdd(link);
    }

    private void addLinkToLogout() {
        JsonRepresentation link = LinkBuilder.newBuilder((IResourceContext)this.resourceContext, (String)Rel.LOGOUT.getName(), (RepresentationType)RepresentationType.HOME_PAGE, (String)"user/logout", (Object[])new Object[0]).build();
        this.getLinks().arrayAdd(link);
    }
}

