/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.viewer.resources;

import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.services.iactnlayer.InteractionLayerTracker;
import org.apache.isis.applib.services.iactnlayer.InteractionService;
import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.security.authentication.manager.AuthenticationManager;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.user.UserResource;
import org.apache.isis.viewer.restfulobjects.rendering.Caching;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.Responses;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.viewer.context.ResourceContext;
import org.apache.isis.viewer.restfulobjects.viewer.resources.HomePageReprRenderer;
import org.apache.isis.viewer.restfulobjects.viewer.resources.ResourceAbstract;
import org.apache.isis.viewer.restfulobjects.viewer.resources.UserReprRenderer;
import org.springframework.stereotype.Component;

@Component
public class UserResourceServerside
extends ResourceAbstract
implements UserResource {
    @Inject
    public UserResourceServerside(MetaModelContext metaModelContext, IsisConfiguration isisConfiguration, InteractionLayerTracker iInteractionLayerTracker) {
        super(metaModelContext, isisConfiguration, iInteractionLayerTracker);
    }

    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/user\""})
    public Response user() {
        ResourceContext resourceContext = this.createResourceContext(RepresentationType.USER, Where.NOWHERE, RepresentationService.Intent.NOT_APPLICABLE);
        UserReprRenderer renderer = new UserReprRenderer(resourceContext, null, JsonRepresentation.newMap((String[])new String[0]));
        renderer.includesSelf().with((Object)resourceContext.getInteractionProvider().currentInteractionContextElseFail());
        return Responses.ofOk((ReprRenderer)renderer, (Caching)Caching.ONE_HOUR).build();
    }

    public Response deleteUserNotAllowed() {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting the user resource is not allowed.", (Object[])new Object[0]);
    }

    public Response putUserNotAllowed() {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Putting to the user resource is not allowed.", (Object[])new Object[0]);
    }

    public Response postUserNotAllowed() {
        throw RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Posting to the user resource is not allowed.", (Object[])new Object[0]);
    }

    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/homepage\""})
    public Response logout() {
        ResourceContext resourceContext = this.createResourceContext(RepresentationType.HOME_PAGE, Where.NOWHERE, RepresentationService.Intent.NOT_APPLICABLE);
        HomePageReprRenderer renderer = new HomePageReprRenderer(resourceContext, null, JsonRepresentation.newMap((String[])new String[0]));
        renderer.includesSelf();
        this.logout(resourceContext);
        try {
            URI location = new URI("?__isis_force_logout");
            return Response.temporaryRedirect((URI)location).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void logout(ResourceContext resourceContext) {
        InteractionService interactionService = resourceContext.getInteractionService();
        InteractionLayerTracker interactionLayerTracker = resourceContext.getInteractionLayerTracker();
        AuthenticationManager authenticationManager = (AuthenticationManager)resourceContext.getMetaModelContext().getServiceRegistry().lookupServiceElseFail(AuthenticationManager.class);
        interactionLayerTracker.currentInteractionContext().ifPresent(interactionContext -> {
            authenticationManager.closeSession(interactionContext);
            interactionService.closeInteractionLayers();
        });
    }
}

