/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.viewer.resources;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.services.iactnlayer.InteractionLayerTracker;
import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.version.VersionResource;
import org.apache.isis.viewer.restfulobjects.rendering.Caching;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.Responses;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.viewer.context.ResourceContext;
import org.apache.isis.viewer.restfulobjects.viewer.resources.ResourceAbstract;
import org.apache.isis.viewer.restfulobjects.viewer.resources.VersionReprRenderer;
import org.apache.isis.viewer.restfulobjects.viewer.resources._EndpointLogging;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
@Path(value="/version")
public class VersionResourceServerside
extends ResourceAbstract
implements VersionResource {
    private static final Logger log = LogManager.getLogger(VersionResourceServerside.class);

    @Inject
    public VersionResourceServerside(MetaModelContext metaModelContext, IsisConfiguration isisConfiguration, InteractionLayerTracker iInteractionLayerTracker) {
        super(metaModelContext, isisConfiguration, iInteractionLayerTracker);
        log.debug("<init>");
    }

    @GET
    @Produces(value={"application/json", "application/json;profile=\"urn:org.restfulobjects:repr-types/version\""})
    public Response version() {
        ResourceContext resourceContext = this.createResourceContext(RepresentationType.VERSION, Where.NOWHERE, RepresentationService.Intent.NOT_APPLICABLE);
        this.fakeRuntimeExceptionIfXFail(resourceContext);
        VersionReprRenderer renderer = new VersionReprRenderer(resourceContext, null, JsonRepresentation.newMap((String[])new String[0]));
        renderer.includesSelf();
        return _EndpointLogging.response(log, "GET /version", Responses.ofOk((ReprRenderer)renderer, (Caching)Caching.ONE_DAY).build());
    }

    public Response deleteVersionNotAllowed() {
        throw _EndpointLogging.error(log, "DELETE /version", RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Deleting the version resource is not allowed.", (Object[])new Object[0]));
    }

    public Response putVersionNotAllowed() {
        throw _EndpointLogging.error(log, "PUT /version", RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Putting to the version resource is not allowed.", (Object[])new Object[0]));
    }

    public Response postVersionNotAllowed() {
        throw _EndpointLogging.error(log, "POST /version", RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_NOT_ALLOWED, (String)"Posting to the version resource is not allowed.", (Object[])new Object[0]));
    }

    private void fakeRuntimeExceptionIfXFail(ResourceContext resourceContext) {
        HttpHeaders httpHeaders = resourceContext.getHttpHeaders();
        List requestHeader = httpHeaders.getRequestHeader("X-Fail");
        if (requestHeader != null && !requestHeader.isEmpty()) {
            throw _EndpointLogging.error(log, "GET /version", RestfulObjectsApplicationException.create((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.METHOD_FAILURE));
        }
    }
}

