/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.viewer.resources.serialization;

import java.util.Collection;
import javax.ws.rs.core.MediaType;
import org.apache.isis.commons.internal.resources._Json;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;

public enum SerializationStrategy {
    XML{

        @Override
        public Object entity(Object jaxbAnnotatedObject) {
            return jaxbAnnotatedObject;
        }
    }
    ,
    JSON{

        @Override
        public Object entity(Object jaxbAnnotatedObject) {
            return _Json.toString((Object)jaxbAnnotatedObject, (_Json.JsonCustomizer[])new _Json.JsonCustomizer[]{_Json::jaxbAnnotationSupport});
        }
    }
    ,
    JSON_INDENTED{

        @Override
        public Object entity(Object jaxbAnnotatedObject) {
            return _Json.toString((Object)jaxbAnnotatedObject, (_Json.JsonCustomizer[])new _Json.JsonCustomizer[]{_Json::jaxbAnnotationSupport, _Json::indentedOutput});
        }
    };


    public abstract Object entity(Object var1);

    public MediaType type(RepresentationType representationType) {
        return representationType.getXmlMediaType();
    }

    public static SerializationStrategy determineFrom(Collection<MediaType> acceptableMediaTypes) {
        for (MediaType acceptableMediaType : acceptableMediaTypes) {
            if (acceptableMediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
                return JSON;
            }
            if (!acceptableMediaType.isCompatible(MediaType.APPLICATION_XML_TYPE)) continue;
            return XML;
        }
        return JSON;
    }
}

