/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.viewer.webmodule;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.TransactionalException;
import org.apache.isis.applib.services.iactnlayer.InteractionContext;
import org.apache.isis.applib.services.iactnlayer.InteractionService;
import org.apache.isis.applib.services.xactn.TransactionService;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.commons.internal.factory._InstanceUtil;
import org.apache.isis.core.metamodel.commons.StringExtensions;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelInvalidException;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;
import org.apache.isis.core.webapp.modules.templresources.TemplateResourceCachingFilter;
import org.apache.isis.viewer.restfulobjects.viewer.webmodule.auth.AuthenticationStrategy;
import org.apache.isis.viewer.restfulobjects.viewer.webmodule.auth.AuthenticationStrategyDefault;
import org.springframework.beans.factory.annotation.Autowired;

public class IsisRestfulObjectsInteractionFilter
implements Filter {
    public static final String AUTHENTICATION_SESSION_STRATEGY_KEY = "authenticationStrategy";
    public static final String AUTHENTICATION_SESSION_STRATEGY_DEFAULT = AuthenticationStrategyDefault.class.getName();
    public static final String LOGON_PAGE_KEY = "logonPage";
    public static final String WHEN_NO_SESSION_KEY = "whenNoSession";
    public static final String PASS_THRU_KEY = "passThru";
    public static final String RESTRICTED_KEY = "restricted";
    public static final String REDIRECT_TO_ON_EXCEPTION_KEY = "redirectToOnException";
    public static final String IGNORE_EXTENSIONS_KEY = "ignoreExtensions";
    public static final String ISIS_SESSION_FILTER_QUERY_STRING_FORCE_LOGOUT = "__isis_force_logout";
    private static final Function<String, Pattern> STRING_TO_PATTERN = input -> Pattern.compile(".*\\." + input);
    @Autowired
    private InteractionService interactionService;
    @Autowired
    private SpecificationLoader specificationLoader;
    @Autowired
    private TransactionService transactionService;
    private List<String> passThruList = Collections.emptyList();
    private AuthenticationStrategy authStrategy;
    private List<String> restrictedPaths;
    private WhenNoSession whenNotAuthenticated;
    private String redirectToOnException;
    private Collection<Pattern> ignoreExtensions;

    static void redirect(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String redirectTo) throws IOException {
        httpResponse.sendRedirect(StringExtensions.combinePath((String)httpRequest.getContextPath(), (String)redirectTo));
    }

    public void init(FilterConfig config) throws ServletException {
        this.authStrategy = IsisRestfulObjectsInteractionFilter.lookup(config.getInitParameter(AUTHENTICATION_SESSION_STRATEGY_KEY));
        this.lookupWhenNoSession(config);
        this.lookupPassThru(config);
        this.lookupRedirectToOnException(config);
        this.lookupIgnoreExtensions(config);
    }

    public static AuthenticationStrategy lookup(String authLookupStrategyClassName) {
        if (authLookupStrategyClassName == null) {
            authLookupStrategyClassName = AUTHENTICATION_SESSION_STRATEGY_DEFAULT;
        }
        return (AuthenticationStrategy)_InstanceUtil.createInstance((String)authLookupStrategyClassName, (Object[])new Object[0]);
    }

    private void lookupWhenNoSession(FilterConfig config) {
        String whenNoSessionStr = config.getInitParameter(WHEN_NO_SESSION_KEY);
        String logonPage = config.getInitParameter(LOGON_PAGE_KEY);
        if (logonPage != null) {
            if (whenNoSessionStr != null) {
                throw new IllegalStateException(String.format("The init-param '%s' is only provided for backwards compatibility; remove if the init-param '%s' has been specified", LOGON_PAGE_KEY, WHEN_NO_SESSION_KEY));
            }
            this.whenNotAuthenticated = WhenNoSession.RESTRICTED;
            this.restrictedPaths = _Lists.of((Object[])new String[]{logonPage});
            return;
        }
        this.whenNotAuthenticated = WhenNoSession.lookup(whenNoSessionStr);
        if (this.whenNotAuthenticated == WhenNoSession.RESTRICTED) {
            String restrictedPathsStr = config.getInitParameter(RESTRICTED_KEY);
            if (restrictedPathsStr == null) {
                throw new IllegalStateException(String.format("Require an init-param of '%s' key to be set.", RESTRICTED_KEY));
            }
            this.restrictedPaths = _Strings.splitThenStream((String)restrictedPathsStr, (String)",").collect(Collectors.toList());
        }
    }

    void lookupPassThru(FilterConfig config) {
        this.passThruList = this.lookupAndParsePassThru(config);
    }

    List<String> lookupAndParsePassThru(FilterConfig config) {
        String passThru = config.getInitParameter(PASS_THRU_KEY);
        return passThru != null && !passThru.equals("") ? Arrays.asList(passThru.split(",")) : Collections.emptyList();
    }

    private void lookupRedirectToOnException(FilterConfig config) {
        this.redirectToOnException = config.getInitParameter(REDIRECT_TO_ON_EXCEPTION_KEY);
    }

    private void lookupIgnoreExtensions(FilterConfig config) {
        this.ignoreExtensions = Collections.unmodifiableCollection(this.parseIgnorePatterns(config).collect(Collectors.toList()));
    }

    private Stream<Pattern> parseIgnorePatterns(FilterConfig config) {
        String ignoreExtensionsStr = config.getInitParameter(IGNORE_EXTENSIONS_KEY);
        if (ignoreExtensionsStr != null) {
            Stream ignoreExtensions = _Strings.splitThenStream((String)ignoreExtensionsStr, (String)",");
            return ignoreExtensions.map(STRING_TO_PATTERN);
        }
        return Stream.empty();
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Objects.requireNonNull(this.interactionService, "isisInteractionFactory");
        Objects.requireNonNull(this.specificationLoader, "specificationLoader");
        IsisRestfulObjectsInteractionFilter.ensureMetamodelIsValid(this.specificationLoader);
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        try {
            String queryString = httpServletRequest.getQueryString();
            if (queryString != null && queryString.contains(ISIS_SESSION_FILTER_QUERY_STRING_FORCE_LOGOUT)) {
                this.authStrategy.invalidate(httpServletRequest, httpServletResponse);
                return;
            }
            if (this.requestIsIgnoreExtension(this, httpServletRequest) || TemplateResourceCachingFilter.isCachedResource((HttpServletRequest)httpServletRequest)) {
                chain.doFilter(request, response);
                return;
            }
            if (this.requestIsPassThru(httpServletRequest)) {
                chain.doFilter(request, response);
                return;
            }
            InteractionContext authentication = this.authStrategy.lookupValid(httpServletRequest, httpServletResponse);
            if (authentication != null) {
                this.authStrategy.bind(httpServletRequest, httpServletResponse, authentication);
                this.interactionService.run(authentication, () -> this.transactionService.runWithinCurrentTransactionElseCreateNew(() -> chain.doFilter(request, response)).mapFailure(e -> new TransactionalException("", e)).optionalElseFail());
                return;
            }
            try {
                this.whenNotAuthenticated.handle(this, httpServletRequest, httpServletResponse, chain);
            }
            catch (IOException | RuntimeException | ServletException ex) {
                if (this.redirectToOnException != null) {
                    IsisRestfulObjectsInteractionFilter.redirect(httpServletRequest, httpServletResponse, this.redirectToOnException);
                    this.interactionService.closeInteractionLayers();
                    return;
                }
                throw ex;
            }
        }
        finally {
            this.interactionService.closeInteractionLayers();
        }
    }

    private static void ensureMetamodelIsValid(SpecificationLoader specificationLoader) {
        ValidationFailures validationResult = (ValidationFailures)specificationLoader.getValidationResult().orElseThrow(() -> _Exceptions.illegalState((String)"Application is not fully initilized yet.", (Object[])new Object[0]));
        if (validationResult.hasFailures()) {
            throw new MetaModelInvalidException(validationResult.getAsLineNumberedString());
        }
    }

    protected boolean requestIsPassThru(HttpServletRequest httpServletRequest) {
        String requestURI = httpServletRequest.getRequestURI();
        for (String passThru : this.passThruList) {
            if (!requestURI.startsWith(passThru)) continue;
            return true;
        }
        return false;
    }

    private boolean requestIsIgnoreExtension(IsisRestfulObjectsInteractionFilter filter, HttpServletRequest httpRequest) {
        String servletPath = httpRequest.getServletPath();
        for (Pattern extension : filter.ignoreExtensions) {
            if (!extension.matcher(servletPath).matches()) continue;
            return true;
        }
        return false;
    }

    public static enum WhenNoSession {
        UNAUTHORIZED("unauthorized"){

            @Override
            public void handle(IsisRestfulObjectsInteractionFilter filter, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
                httpResponse.sendError(401);
            }
        }
        ,
        BASIC_AUTH_CHALLENGE("basicAuthChallenge"){

            @Override
            public void handle(IsisRestfulObjectsInteractionFilter filter, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
                httpResponse.setHeader("WWW-Authenticate", "Basic realm=\"Apache Isis\"");
                httpResponse.sendError(401);
            }
        }
        ,
        AUTO("auto"){

            @Override
            public void handle(IsisRestfulObjectsInteractionFilter filter, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
                if (this.fromWebBrowser(httpRequest)) {
                    httpResponse.setHeader("WWW-Authenticate", "Basic realm=\"Apache Isis\"");
                }
                httpResponse.sendError(401);
            }

            private boolean fromWebBrowser(HttpServletRequest httpRequest) {
                String accept = httpRequest.getHeader("Accept");
                return accept.contains("text/html");
            }
        }
        ,
        CONTINUE("continue"){

            @Override
            public void handle(IsisRestfulObjectsInteractionFilter filter, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
        }
        ,
        RESTRICTED("restricted"){

            @Override
            public void handle(IsisRestfulObjectsInteractionFilter filter, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
                if (filter.restrictedPaths.contains(httpRequest.getServletPath())) {
                    chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                    return;
                }
                IsisRestfulObjectsInteractionFilter.redirect(httpRequest, httpResponse, filter.restrictedPaths.get(0));
            }
        };

        private final String initParamValue;

        private WhenNoSession(String initParamValue) {
            this.initParamValue = initParamValue;
        }

        public static WhenNoSession lookup(String whenNoSessionStr) {
            for (WhenNoSession wns : WhenNoSession.values()) {
                if (!wns.initParamValue.equals(whenNoSessionStr)) continue;
                return wns;
            }
            throw new IllegalStateException("require an init-param of 'whenNoSession', taking a value of " + WhenNoSession.values());
        }

        public abstract void handle(IsisRestfulObjectsInteractionFilter var1, HttpServletRequest var2, HttpServletResponse var3, FilterChain var4) throws IOException, ServletException;
    }
}

