/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.viewer.webmodule.auth;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.isis.applib.services.iactnlayer.InteractionContext;
import org.apache.isis.commons.internal.base._Bytes;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.security.authentication.AuthenticationRequest;
import org.apache.isis.core.security.authentication.AuthenticationRequestPassword;
import org.apache.isis.core.security.authentication.manager.AuthenticationManager;
import org.apache.isis.viewer.restfulobjects.viewer.webmodule.auth.AuthenticationStrategyAbstract;

public class AuthenticationStrategyBasicAuth
extends AuthenticationStrategyAbstract {
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String BASIC_AUTH_PREFIX = "Basic ";
    private static Pattern USER_AND_PASSWORD_REGEX = Pattern.compile("^(.+):(.+)$");

    @Override
    public InteractionContext lookupValid(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        httpServletRequest.setAttribute("org.apache.shiro.subject.support.DefaultSubjectContext.SESSION_CREATION_ENABLED", (Object)Boolean.FALSE);
        String digest = this.getBasicAuthDigest(httpServletRequest);
        if (digest == null) {
            return null;
        }
        String userAndPassword = this.unencoded(digest);
        Matcher matcher = USER_AND_PASSWORD_REGEX.matcher(userAndPassword);
        if (!matcher.matches()) {
            return null;
        }
        String user = matcher.group(1);
        String password = matcher.group(2);
        AuthenticationRequestPassword authenticationRequestPwd = new AuthenticationRequestPassword(user, password);
        AuthenticationManager authenticationManager = super.getAuthenticationManager((ServletRequest)httpServletRequest);
        InteractionContext authentication = authenticationManager.authenticate((AuthenticationRequest)authenticationRequestPwd);
        return authentication;
    }

    @Override
    public void bind(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, InteractionContext auth) {
    }

    private String getBasicAuthDigest(HttpServletRequest httpServletRequest) {
        String authStr = httpServletRequest.getHeader(HEADER_AUTHORIZATION);
        return authStr != null && authStr.startsWith(BASIC_AUTH_PREFIX) ? authStr.substring(BASIC_AUTH_PREFIX.length()) : null;
    }

    protected String unencoded(String encodedDigest) {
        return _Strings.ofBytes((byte[])_Bytes.decodeBase64((Base64.Decoder)Base64.getUrlDecoder(), (byte[])encodedDigest.getBytes()), (Charset)StandardCharsets.UTF_8);
    }
}

