/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.viewer.webmodule.auth;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.isis.applib.services.iactnlayer.InteractionContext;
import org.apache.isis.core.security.authentication.manager.AuthenticationManager;
import org.apache.isis.viewer.restfulobjects.viewer.webmodule.auth.AuthenticationStrategyAbstract;

public class AuthenticationStrategyDefault
extends AuthenticationStrategyAbstract {
    public static final String HTTP_SESSION_AUTHENTICATION_SESSION_KEY = AuthenticationStrategyDefault.class.getPackage().getName() + ".authentication";

    @Override
    public InteractionContext lookupValid(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        boolean sessionValid;
        AuthenticationManager authenticationManager = super.getAuthenticationManager((ServletRequest)httpServletRequest);
        HttpSession httpSession = this.getHttpSession((ServletRequest)httpServletRequest);
        InteractionContext authentication = (InteractionContext)httpSession.getAttribute(HTTP_SESSION_AUTHENTICATION_SESSION_KEY);
        if (authentication != null && (sessionValid = authenticationManager.isSessionValid(authentication))) {
            return authentication;
        }
        return null;
    }

    @Override
    public void bind(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, InteractionContext authentication) {
        HttpSession httpSession = this.getHttpSession((ServletRequest)httpServletRequest);
        if (authentication != null) {
            httpSession.setAttribute(HTTP_SESSION_AUTHENTICATION_SESSION_KEY, (Object)authentication);
        } else {
            httpSession.removeAttribute(HTTP_SESSION_AUTHENTICATION_SESSION_KEY);
        }
    }
}

