/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui;

import java.io.Serializable;
import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.CssResourceReference;

public interface ComponentFactory
extends Serializable {
    public ComponentType getComponentType();

    public Class<?> getComponentTypeClass();

    public ApplicationAdvice appliesTo(ComponentType var1, IModel<?> var2);

    public Component createComponent(IModel<?> var1);

    public Component createComponent(String var1, IModel<?> var2);

    public String getName();

    public CssResourceReference getCssResourceReference();

    public static enum ApplicationAdvice {
        APPLIES,
        APPLIES_EXCLUSIVELY,
        DOES_NOT_APPLY;


        public boolean applies() {
            return this == APPLIES || this == APPLIES_EXCLUSIVELY;
        }

        public boolean appliesExclusively() {
            return this == APPLIES_EXCLUSIVELY;
        }

        public static final ApplicationAdvice appliesIf(boolean condition) {
            return condition ? APPLIES : DOES_NOT_APPLY;
        }

        public static final ApplicationAdvice appliesExclusivelyIf(boolean condition) {
            return condition ? APPLIES_EXCLUSIVELY : DOES_NOT_APPLY;
        }
    }
}

