/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.actionresponse;

import java.net.URL;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.applib.value.LocalResourcePath;
import org.apache.isis.applib.value.OpenUrlStrategy;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.assertions._Assert;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.core.config.viewer.web.WebAppContextPath;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ManagedObjects;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.PackedManagedObject;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModelStandalone;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.model.models.ValueModel;
import org.apache.isis.viewer.wicket.model.models.VoidModel;
import org.apache.isis.viewer.wicket.ui.actionresponse.ActionResultResponse;
import org.apache.isis.viewer.wicket.ui.actionresponse.PageRedirectRequest;
import org.apache.isis.viewer.wicket.ui.actionresponse._DownloadHandler;
import org.apache.isis.viewer.wicket.ui.actionresponse._RedirectHandler;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.entity.EntityPage;
import org.apache.isis.viewer.wicket.ui.pages.standalonecollection.StandaloneCollectionPage;
import org.apache.isis.viewer.wicket.ui.pages.value.ValuePage;
import org.apache.isis.viewer.wicket.ui.pages.voidreturn.VoidReturnPage;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.request.IRequestHandler;

public enum ActionResultResponseType {
    OBJECT{

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, AjaxRequestTarget target, ManagedObject resultAdapter, Can<ManagedObject> args) {
            ActionResultResponseType.determineScalarAdapter(actionModel.getCommonContext(), resultAdapter);
            return 1.toEntityPage(resultAdapter);
        }

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, ManagedObject targetAdapter) {
            return 1.toEntityPage(targetAdapter);
        }
    }
    ,
    COLLECTION{

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, AjaxRequestTarget target, ManagedObject resultAdapter, Can<ManagedObject> args) {
            _Assert.assertTrue((boolean)(resultAdapter instanceof PackedManagedObject));
            EntityCollectionModelStandalone collectionModel = EntityCollectionModelStandalone.forActionModel((PackedManagedObject)((PackedManagedObject)resultAdapter), (ActionModel)actionModel, args);
            return ActionResultResponse.toPage(StandaloneCollectionPage.class, new StandaloneCollectionPage(collectionModel));
        }
    }
    ,
    VALUE{

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, AjaxRequestTarget target, ManagedObject resultAdapter, Can<ManagedObject> args) {
            IsisAppCommonContext commonContext = actionModel.getCommonContext();
            ValueModel valueModel = ValueModel.of((IsisAppCommonContext)commonContext, (ManagedObject)resultAdapter);
            valueModel.setActionHint(actionModel);
            ValuePage valuePage = new ValuePage(valueModel);
            return ActionResultResponse.toPage(ValuePage.class, valuePage);
        }
    }
    ,
    VALUE_CLOB{

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, AjaxRequestTarget target, ManagedObject resultAdapter, Can<ManagedObject> args) {
            Object value = resultAdapter.getPojo();
            IRequestHandler handler = _DownloadHandler.downloadHandler(actionModel.getAction(), value);
            return ActionResultResponse.withHandler(handler);
        }
    }
    ,
    VALUE_BLOB{

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, AjaxRequestTarget target, ManagedObject resultAdapter, Can<ManagedObject> args) {
            Object value = resultAdapter.getPojo();
            IRequestHandler handler = _DownloadHandler.downloadHandler(actionModel.getAction(), value);
            return ActionResultResponse.withHandler(handler);
        }
    }
    ,
    VALUE_LOCALRESPATH_AJAX{

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, AjaxRequestTarget target, ManagedObject resultAdapter, Can<ManagedObject> args) {
            LocalResourcePath localResPath = (LocalResourcePath)resultAdapter.getPojo();
            WebAppContextPath webAppContextPath = actionModel.getCommonContext().getWebAppContextPath();
            return ActionResultResponse.openUrlInBrowser(target, localResPath.getEffectivePath(arg_0 -> ((WebAppContextPath)webAppContextPath).prependContextPath(arg_0)), localResPath.getOpenUrlStrategy());
        }
    }
    ,
    VALUE_LOCALRESPATH_NOAJAX{

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, AjaxRequestTarget target, ManagedObject resultAdapter, Can<ManagedObject> args) {
            LocalResourcePath localResPath = (LocalResourcePath)resultAdapter.getPojo();
            WebAppContextPath webAppContextPath = actionModel.getCommonContext().getWebAppContextPath();
            IRequestHandler handler = _RedirectHandler.redirectHandler(localResPath, localResPath.getOpenUrlStrategy(), webAppContextPath);
            return ActionResultResponse.withHandler(handler);
        }
    }
    ,
    VALUE_URL_AJAX{

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, AjaxRequestTarget target, ManagedObject resultAdapter, Can<ManagedObject> args) {
            URL url = (URL)resultAdapter.getPojo();
            return ActionResultResponse.openUrlInBrowser(target, url.toString(), OpenUrlStrategy.NEW_WINDOW);
        }
    }
    ,
    VALUE_URL_NOAJAX{

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, AjaxRequestTarget target, ManagedObject resultAdapter, Can<ManagedObject> args) {
            Object value = resultAdapter.getPojo();
            WebAppContextPath webAppContextPath = actionModel.getCommonContext().getWebAppContextPath();
            IRequestHandler handler = _RedirectHandler.redirectHandler(value, OpenUrlStrategy.NEW_WINDOW, webAppContextPath);
            return ActionResultResponse.withHandler(handler);
        }
    }
    ,
    VOID{

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, AjaxRequestTarget target, ManagedObject resultAdapter, Can<ManagedObject> args) {
            IsisAppCommonContext commonContext = actionModel.getCommonContext();
            VoidModel voidModel = new VoidModel(commonContext);
            voidModel.setActionHint(actionModel);
            return ActionResultResponse.toPage(VoidReturnPage.class, new VoidReturnPage(voidModel));
        }
    }
    ,
    SIGN_IN{

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, AjaxRequestTarget target, ManagedObject resultAdapter, Can<ManagedObject> args) {
            Class<? extends Page> signInPage = ((PageClassRegistry)actionModel.getCommonContext().lookupServiceElseFail(PageClassRegistry.class)).getPageClass(PageType.SIGN_IN);
            return ActionResultResponse.toPage(PageRedirectRequest.forPageClass(signInPage));
        }
    };


    public abstract ActionResultResponse interpretResult(ActionModel var1, AjaxRequestTarget var2, ManagedObject var3, Can<ManagedObject> var4);

    public ActionResultResponse interpretResult(ActionModel model, ManagedObject targetAdapter) {
        throw new UnsupportedOperationException("Cannot render concurrency exception for any result type other than OBJECT");
    }

    public static ActionResultResponse determineAndInterpretResult(ActionModel model, AjaxRequestTarget targetIfAny, ManagedObject resultAdapter, Can<ManagedObject> args) {
        TypeAndAdapter typeAndAdapter = ActionResultResponseType.determineFor(resultAdapter, targetIfAny);
        return typeAndAdapter.type.interpretResult(model, targetIfAny, typeAndAdapter.resultAdapter, args);
    }

    public static ActionResultResponse toEntityPage(ManagedObject entityOrViewmodel) {
        return ActionResultResponse.toPage(EntityPage.class, (Bookmark)entityOrViewmodel.getBookmarkRefreshed().orElseThrow());
    }

    private static ManagedObject determineScalarAdapter(IsisAppCommonContext commonContext, ManagedObject resultAdapter) {
        if (resultAdapter.getSpecification().isScalar()) {
            return resultAdapter;
        }
        Object pojo = _NullSafe.streamAutodetect((Object)resultAdapter.getPojo()).findFirst().orElseThrow(_Exceptions::noSuchElement);
        ManagedObject scalarAdapter = commonContext.getObjectManager().adapt(pojo);
        return scalarAdapter;
    }

    private static TypeAndAdapter determineFor(ManagedObject resultAdapter, AjaxRequestTarget targetIfAny) {
        if (ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)resultAdapter)) {
            return TypeAndAdapter.of(VOID, resultAdapter);
        }
        ObjectSpecification resultSpec = resultAdapter.getSpecification();
        if (!(resultAdapter instanceof PackedManagedObject)) {
            _Assert.assertTrue((boolean)resultSpec.isScalar());
            if ("isis.security.LoginRedirect".equals(resultSpec.getLogicalTypeName())) {
                return TypeAndAdapter.of(SIGN_IN, resultAdapter);
            }
            if (resultSpec.isValue()) {
                Object value = resultAdapter.getPojo();
                if (value instanceof Clob) {
                    return TypeAndAdapter.of(VALUE_CLOB, resultAdapter);
                }
                if (value instanceof Blob) {
                    return TypeAndAdapter.of(VALUE_BLOB, resultAdapter);
                }
                if (value instanceof LocalResourcePath) {
                    return targetIfAny != null ? TypeAndAdapter.of(VALUE_LOCALRESPATH_AJAX, resultAdapter) : TypeAndAdapter.of(VALUE_LOCALRESPATH_NOAJAX, resultAdapter);
                }
                if (value instanceof URL) {
                    return targetIfAny != null ? TypeAndAdapter.of(VALUE_URL_AJAX, resultAdapter) : TypeAndAdapter.of(VALUE_URL_NOAJAX, resultAdapter);
                }
                return TypeAndAdapter.of(VALUE, resultAdapter);
            }
            return TypeAndAdapter.of(OBJECT, resultAdapter);
        }
        PackedManagedObject packedAdapter = (PackedManagedObject)resultAdapter;
        Can unpacked = packedAdapter.unpack();
        int cardinality = unpacked.size();
        switch (cardinality) {
            case 1: {
                ManagedObject firstElement = (ManagedObject)unpacked.getFirstOrFail();
                return ActionResultResponseType.determineFor(firstElement, targetIfAny);
            }
        }
        return TypeAndAdapter.of(COLLECTION, resultAdapter);
    }

    private static final class TypeAndAdapter {
        private final ActionResultResponseType type;
        private final ManagedObject resultAdapter;

        private TypeAndAdapter(ActionResultResponseType type, ManagedObject resultAdapter) {
            this.type = type;
            this.resultAdapter = resultAdapter;
        }

        public static TypeAndAdapter of(ActionResultResponseType type, ManagedObject resultAdapter) {
            return new TypeAndAdapter(type, resultAdapter);
        }

        public ActionResultResponseType getType() {
            return this.type;
        }

        public ManagedObject getResultAdapter() {
            return this.resultAdapter;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeAndAdapter)) {
                return false;
            }
            TypeAndAdapter other = (TypeAndAdapter)o;
            ActionResultResponseType this$type = this.getType();
            ActionResultResponseType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            ManagedObject this$resultAdapter = this.getResultAdapter();
            ManagedObject other$resultAdapter = other.getResultAdapter();
            return !(this$resultAdapter == null ? other$resultAdapter != null : !this$resultAdapter.equals(other$resultAdapter));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ActionResultResponseType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            ManagedObject $resultAdapter = this.getResultAdapter();
            result = result * 59 + ($resultAdapter == null ? 43 : $resultAdapter.hashCode());
            return result;
        }

        public String toString() {
            return "ActionResultResponseType.TypeAndAdapter(type=" + this.getType() + ", resultAdapter=" + this.getResultAdapter() + ")";
        }
    }
}

