/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.actionresponse;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.applib.value.NamedWithMimeType;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.resource.StringResourceStream;
import org.apache.wicket.util.time.Duration;

final class _DownloadHandler {
    public static IRequestHandler downloadHandler(ObjectAction action, Object value) {
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            return _DownloadHandler.handlerFor(action, _DownloadHandler.resourceStreamFor(clob), (NamedWithMimeType)clob);
        }
        if (value instanceof Blob) {
            Blob blob = (Blob)value;
            return _DownloadHandler.handlerFor(action, _DownloadHandler.resourceStreamFor(blob), (NamedWithMimeType)blob);
        }
        return null;
    }

    private static IResourceStream resourceStreamFor(final Blob blob) {
        AbstractResourceStream resourceStream = new AbstractResourceStream(){
            private static final long serialVersionUID = 1L;

            public InputStream getInputStream() throws ResourceStreamNotFoundException {
                return new ByteArrayInputStream(blob.getBytes());
            }

            public String getContentType() {
                return blob.getMimeType().toString();
            }

            public void close() throws IOException {
            }
        };
        return resourceStream;
    }

    private static IResourceStream resourceStreamFor(Clob clob) {
        return new StringResourceStream(clob.getChars(), clob.getMimeType().toString());
    }

    private static IRequestHandler handlerFor(ObjectAction action, IResourceStream resourceStream, NamedWithMimeType namedWithMimeType) {
        ResourceStreamRequestHandler handler = new ResourceStreamRequestHandler(resourceStream, namedWithMimeType.getName());
        handler.setContentDisposition(ContentDisposition.ATTACHMENT);
        return action.getSemantics().isIdempotentOrCachable() ? handler : _DownloadHandler.enforceNoCacheOnClientSide((IRequestHandler)handler);
    }

    private static IRequestHandler enforceNoCacheOnClientSide(IRequestHandler downloadHandler) {
        if (downloadHandler == null) {
            return downloadHandler;
        }
        if (downloadHandler instanceof ResourceStreamRequestHandler) {
            ((ResourceStreamRequestHandler)downloadHandler).setCacheDuration(Duration.seconds((int)0));
        }
        return downloadHandler;
    }

    private _DownloadHandler() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

