/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.app.logout;

import org.apache.isis.applib.services.iactnlayer.InteractionLayerTracker;
import org.apache.isis.core.interaction.session.IsisInteraction;
import org.apache.isis.core.security.authentication.logout.LogoutHandler;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.request.cycle.RequestCycle;
import org.springframework.stereotype.Service;

@Service
public class LogoutHandlerWkt
implements LogoutHandler {
    final InteractionLayerTracker interactionLayerTracker;

    public void logout() {
        AuthenticatedWebSession currentWktSession = AuthenticatedWebSession.get();
        if (currentWktSession == null) {
            return;
        }
        if (this.interactionLayerTracker.isInInteraction()) {
            this.interactionLayerTracker.currentInteraction().map(IsisInteraction.class::cast).ifPresent(interaction -> interaction.setOnClose(() -> ((AuthenticatedWebSession)currentWktSession).invalidateNow()));
        } else {
            currentWktSession.invalidateNow();
        }
    }

    public boolean isHandlingCurrentThread() {
        return RequestCycle.get() != null;
    }

    public LogoutHandlerWkt(InteractionLayerTracker interactionLayerTracker) {
        this.interactionLayerTracker = interactionLayerTracker;
    }
}

