/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.app.registry;

import java.util.stream.Stream;
import org.apache.isis.commons.collections.ImmutableEnumSet;
import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.model.IModel;
import org.springframework.lang.Nullable;

public interface ComponentFactoryRegistry {
    public Stream<ComponentFactory> streamComponentFactories(ComponentType var1, @Nullable IModel<?> var2);

    public Stream<ComponentFactory> streamComponentFactories(ImmutableEnumSet<ComponentType> var1, @Nullable IModel<?> var2);

    default public ComponentFactory findComponentFactory(ComponentType componentType, @Nullable IModel<?> model) {
        return this.streamComponentFactories(componentType, model).findFirst().orElseGet(() -> this.streamComponentFactories(ComponentType.UNKNOWN, model).findFirst().orElse(null));
    }

    default public ComponentFactory findComponentFactoryElseFail(ComponentType componentType, @Nullable IModel<?> model) {
        return this.streamComponentFactories(componentType, model).findFirst().orElseThrow(() -> new RuntimeException(String.format("could not find component for componentType = '%s'; model object is of type %s; model object='%s'", componentType, model.getClass().getName(), model.getObject())));
    }

    public Component addOrReplaceComponent(MarkupContainer var1, ComponentType var2, IModel<?> var3);

    public Component addOrReplaceComponent(MarkupContainer var1, String var2, ComponentType var3, IModel<?> var4);

    public Component createComponent(ComponentType var1, IModel<?> var2);

    public Component createComponent(ComponentType var1, String var2, IModel<?> var3);
}

