/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components;

import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.core.config.viewer.web.WebAppContextPath;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.wicket.model.util.CommonContextUtils;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.model.IModel;

public abstract class WebComponentBase
extends WebComponent
implements IsisAppCommonContext.HasCommonContext {
    private static final long serialVersionUID = 1L;
    private transient IsisConfiguration isisConfiguration;
    private transient WebAppContextPath webAppContextPath;
    private transient IsisAppCommonContext commonContext;

    public WebComponentBase(String id) {
        super(id);
    }

    public WebComponentBase(String id, IModel<?> model) {
        super(id, model);
    }

    public IsisAppCommonContext getCommonContext() {
        this.commonContext = CommonContextUtils.computeIfAbsent((IsisAppCommonContext)this.commonContext);
        return this.commonContext;
    }

    public IsisConfiguration getIsisConfiguration() {
        this.isisConfiguration = this.computeIfAbsent(IsisConfiguration.class, this.isisConfiguration);
        return this.isisConfiguration;
    }

    public WebAppContextPath getWebAppContextPath() {
        this.webAppContextPath = this.computeIfAbsent(WebAppContextPath.class, this.webAppContextPath);
        return this.webAppContextPath;
    }

    private <X> X computeIfAbsent(Class<X> type, X existingIfAny) {
        return (X)(existingIfAny != null ? existingIfAny : this.getCommonContext().lookupServiceElseFail(type));
    }
}

