/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions;

import java.io.Serializable;
import java.util.List;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.links.ListOfLinksModel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksAsDropDownPanel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksAsListInlinePanel;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.isis.viewer.wicket.ui.util.WktLinks;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.danekja.java.util.function.serializable.SerializableBooleanSupplier;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public class AdditionalLinksPanel
extends PanelAbstract<List<LinkAndLabel>, ListOfLinksModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_ADDITIONAL_LINK_LIST = "additionalLinkList";
    private static final String ID_ADDITIONAL_LINK_ITEM = "additionalLinkItem";
    private static final String ID_ADDITIONAL_LINK_TITLE = "additionalLinkTitle";
    public static final String ID_ADDITIONAL_LINK = "additionalLink";

    public static AdditionalLinksPanel addAdditionalLinks(MarkupContainer markupContainer, String id, Can<LinkAndLabel> links, Style style) {
        if (links.isEmpty()) {
            Components.permanentlyHide(markupContainer, id);
            return null;
        }
        return Wkt.add(markupContainer, style.newPanel(id, links));
    }

    protected AdditionalLinksPanel(String id, Can<LinkAndLabel> linksDoNotUseDirectlyInsteadUseOfListOfLinksModel) {
        super(id, new ListOfLinksModel(linksDoNotUseDirectlyInsteadUseOfListOfLinksModel));
        this.setOutputMarkupId(true);
        WebMarkupContainer container = Wkt.add((MarkupContainer)this, Wkt.containerWithVisibility(ID_ADDITIONAL_LINK_LIST, (SerializableBooleanSupplier & Serializable)() -> ((ListOfLinksModel)this.getModel()).hasAnyVisibleLink()));
        Wkt.listViewAdd((MarkupContainer)container, ID_ADDITIONAL_LINK_ITEM, this.getModel(), (SerializableConsumer & Serializable)item -> {
            LinkAndLabel linkAndLabel = (LinkAndLabel)item.getModelObject();
            item.addOrReplace(new Component[]{WktLinks.asAdditionalLink(ID_ADDITIONAL_LINK_TITLE, linkAndLabel)});
        });
    }

    public static enum Style {
        INLINE_LIST{

            @Override
            AdditionalLinksPanel newPanel(String id, Can<LinkAndLabel> links) {
                return new AdditionalLinksAsListInlinePanel(id, links);
            }
        }
        ,
        DROPDOWN{

            @Override
            AdditionalLinksPanel newPanel(String id, Can<LinkAndLabel> links) {
                return new AdditionalLinksAsDropDownPanel(id, links);
            }
        };


        abstract AdditionalLinksPanel newPanel(String var1, Can<LinkAndLabel> var2);
    }
}

