/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions;

import java.util.function.Function;
import lombok.NonNull;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ManagedObjects;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.viewer.wicket.model.links.ActionLinkUiComponentFactoryWkt;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.ActionModelImpl;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModelParented;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.model.models.ScalarParameterModel;
import org.apache.isis.viewer.wicket.model.models.ScalarPropertyModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.linkandlabel.ActionLink;
import org.apache.wicket.markup.html.link.AbstractLink;

@FunctionalInterface
public interface LinkAndLabelFactory
extends Function<ObjectAction, LinkAndLabel> {
    public static LinkAndLabelFactory forMenu(EntityModel serviceModel) {
        MenuLinkFactory linkFactory = new MenuLinkFactory();
        return action -> LinkAndLabel.of((ActionModel)ActionModelImpl.forEntity((EntityModel)serviceModel, (Identifier)action.getFeatureIdentifier(), (Where)Where.ANYWHERE, null, null, null), (ActionLinkUiComponentFactoryWkt)linkFactory);
    }

    public static LinkAndLabelFactory forEntity(EntityModel parentEntityModel) {
        LinkAndLabelFactory.guardAgainstNotBookmarkable(parentEntityModel.getBookmarkedOwner());
        AdditionalLinkFactory linkFactory = new AdditionalLinkFactory();
        return action -> LinkAndLabel.of((ActionModel)ActionModelImpl.forEntity((EntityModel)parentEntityModel, (Identifier)action.getFeatureIdentifier(), (Where)Where.OBJECT_FORMS, null, null, null), (ActionLinkUiComponentFactoryWkt)linkFactory);
    }

    public static LinkAndLabelFactory forCollection(EntityCollectionModelParented collectionModel) {
        AdditionalLinkFactory linkFactory = new AdditionalLinkFactory();
        return action -> LinkAndLabel.of((ActionModel)ActionModelImpl.forEntity((EntityModel)collectionModel.getEntityModel(), (Identifier)action.getFeatureIdentifier(), (Where)Where.OBJECT_FORMS, null, null, (EntityCollectionModel)collectionModel), (ActionLinkUiComponentFactoryWkt)linkFactory);
    }

    public static LinkAndLabelFactory forPropertyOrParameter(ScalarModel scalarModel) {
        return scalarModel instanceof ScalarPropertyModel ? LinkAndLabelFactory.forProperty((ScalarPropertyModel)scalarModel) : LinkAndLabelFactory.forParameter((ScalarParameterModel)scalarModel);
    }

    public static LinkAndLabelFactory forProperty(ScalarPropertyModel propertyModel) {
        AdditionalLinkFactory linkFactory = new AdditionalLinkFactory();
        return action -> LinkAndLabel.of((ActionModel)ActionModelImpl.forEntity((EntityModel)propertyModel.getParentUiModel(), (Identifier)action.getFeatureIdentifier(), (Where)Where.OBJECT_FORMS, (ScalarPropertyModel)propertyModel, null, null), (ActionLinkUiComponentFactoryWkt)linkFactory);
    }

    public static LinkAndLabelFactory forParameter(ScalarParameterModel parameterModel) {
        if (parameterModel.getMetaModel().isScalar() && parameterModel.getMetaModel().getElementType().isValue()) {
            AdditionalLinkFactory linkFactory = new AdditionalLinkFactory();
            return action -> LinkAndLabel.of((ActionModel)ActionModelImpl.forEntity((EntityModel)parameterModel.getParentUiModel(), (Identifier)action.getFeatureIdentifier(), (Where)Where.OBJECT_FORMS, null, (ScalarParameterModel)parameterModel, null), (ActionLinkUiComponentFactoryWkt)linkFactory);
        }
        return action -> null;
    }

    private static void guardAgainstNotBookmarkable(ManagedObject objectAdapter) {
        boolean isIdentifiable = ManagedObjects.isIdentifiable((ManagedObject)objectAdapter);
        if (!isIdentifiable) {
            throw new IllegalArgumentException(String.format("Object '%s' is not identifiable (has no identifier).", objectAdapter.titleString()));
        }
    }

    public static class AdditionalLinkFactory
    implements ActionLinkUiComponentFactoryWkt {
        private static final long serialVersionUID = 1L;

        public AbstractLink newActionLinkUiComponent(@NonNull ActionModel actionModel) {
            if (actionModel == null) {
                throw new NullPointerException("actionModel is marked non-null but is null");
            }
            return ActionLink.create("additionalLink", actionModel);
        }
    }

    public static class MenuLinkFactory
    implements ActionLinkUiComponentFactoryWkt {
        private static final long serialVersionUID = 1L;

        public AbstractLink newActionLinkUiComponent(@NonNull ActionModel actionModel) {
            if (actionModel == null) {
                throw new NullPointerException("actionModel is marked non-null but is null");
            }
            return ActionLink.create("menuLink", actionModel);
        }
    }
}

