/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions.CssMenuItem;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions.ServiceActionUtil;
import org.apache.isis.viewer.wicket.ui.panels.PanelBase;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public abstract class MenuActionPanel
extends PanelBase {
    private static final long serialVersionUID = 1L;

    public MenuActionPanel(String id) {
        super(id);
    }

    protected ListView<CssMenuItem> subMenuItemsView(List<CssMenuItem> subMenuItems) {
        return Wkt.listView("subMenuItems", subMenuItems, (SerializableConsumer & Serializable)listItem -> {
            CssMenuItem subMenuItem = (CssMenuItem)listItem.getModelObject();
            switch (subMenuItem.getItemType()) {
                case SPACER: {
                    this.addSpacer(subMenuItem, (ListItem<CssMenuItem>)listItem);
                    return;
                }
                case SECTION_LABEL: {
                    this.addSectionLabel(subMenuItem, (ListItem<CssMenuItem>)listItem);
                    return;
                }
            }
            if (subMenuItem.hasSubMenuItems()) {
                this.addFolderItem(subMenuItem, (ListItem<CssMenuItem>)listItem);
            } else {
                this.addLeafItem(subMenuItem, (ListItem<CssMenuItem>)listItem);
            }
        });
    }

    protected List<CssMenuItem> flatten(List<CssMenuItem> menuItems) {
        ArrayList subMenuItems = _Lists.newArrayList();
        for (CssMenuItem menuItem : menuItems) {
            subMenuItems.addAll(menuItem.getSubMenuItems());
        }
        return subMenuItems;
    }

    private void addFolderItem(CssMenuItem menuItem, ListItem<CssMenuItem> listItem) {
        MenuActionPanel parent = this;
        ServiceActionUtil.addFolderItem(super.getCommonContext(), menuItem, listItem, (MarkupContainer)parent);
    }

    private void addLeafItem(CssMenuItem menuItem, ListItem<CssMenuItem> listItem) {
        MenuActionPanel parent = this;
        ServiceActionUtil.addLeafItem(super.getCommonContext(), menuItem, listItem, (MarkupContainer)parent);
    }

    private void addSpacer(CssMenuItem menuItem, ListItem<CssMenuItem> listItem) {
        MenuActionPanel parent = this;
        Fragment fragment = new Fragment("content", "separatorItem", (MarkupContainer)parent);
        listItem.add(new Component[]{fragment});
        Wkt.cssAppend(listItem, "list-separator");
    }

    private void addSectionLabel(CssMenuItem menuItem, ListItem<CssMenuItem> listItem) {
        MenuActionPanel parent = this;
        Fragment fragment = new Fragment("content", "sectionItem", (MarkupContainer)parent);
        Wkt.labelAdd((MarkupContainer)fragment, "sectionLabel", menuItem.getName());
        listItem.add(new Component[]{fragment});
        Wkt.cssAppend(listItem, "list-section-label");
    }
}

