/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actions;

import java.util.Optional;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.commons.internal.base._Either;
import org.apache.isis.commons.internal.debug._Debug;
import org.apache.isis.commons.internal.debug.xray.XrayUi;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.core.metamodel.interactions.managed.ParameterNegotiationModel;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ManagedObjects;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.common.model.decorator.confirm.ConfirmUiModel;
import org.apache.isis.viewer.common.model.feature.ParameterUiModel;
import org.apache.isis.viewer.wicket.model.hints.IsisActionCompletedEvent;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.ScalarParameterModel;
import org.apache.isis.viewer.wicket.model.models.ScalarPropertyModel;
import org.apache.isis.viewer.wicket.model.models.interaction.act.ParameterUiModelWkt;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.panels.PromptFormAbstract;
import org.apache.isis.viewer.wicket.ui.util.Decorators;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;

class ActionParametersForm
extends PromptFormAbstract<ActionModel> {
    private static final long serialVersionUID = 1L;

    public ActionParametersForm(String id, Component parentPanel, WicketViewerSettings settings, ActionModel actionModel) {
        super(id, parentPanel, settings, actionModel);
    }

    private ActionModel getActionModel() {
        return (ActionModel)super.getModel();
    }

    @Override
    protected void addParameters() {
        ActionModel actionModel = this.getActionModel();
        RepeatingView repeatingView = Wkt.add((MarkupContainer)this, new RepeatingView("parameters"));
        this.paramPanels.clear();
        actionModel.streamPendingParamUiModels().map(ParameterUiModelWkt.class::cast).forEach(paramModel -> {
            WebMarkupContainer container = Wkt.containerAdd((MarkupContainer)repeatingView, repeatingView.newChildId());
            this.newParamPanel(container, (ParameterUiModelWkt)paramModel).ifPresent(this.paramPanels::add);
        });
        this.setOutputMarkupId(true);
    }

    private Optional<ScalarPanelAbstract> newParamPanel(WebMarkupContainer container, ParameterUiModelWkt paramModel) {
        String id = "scalarNameAndValue";
        ScalarParameterModel scalarParamModel = ScalarParameterModel.wrap((ParameterUiModelWkt)paramModel);
        Component component = this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)container, "scalarNameAndValue", ComponentType.SCALAR_NAME_AND_VALUE, (IModel<?>)scalarParamModel);
        if (!(component instanceof ScalarPanelAbstract)) {
            return Optional.empty();
        }
        if (component instanceof MarkupContainer) {
            Wkt.cssAppend(component, scalarParamModel.getCssClass());
        }
        ScalarPanelAbstract paramPanel = (ScalarPanelAbstract)component;
        paramPanel.setOutputMarkupId(true);
        paramPanel.notifyOnChange(this);
        return Optional.of(paramPanel);
    }

    @Override
    protected Object newCompletedEvent(AjaxRequestTarget target, Form<?> form) {
        return new IsisActionCompletedEvent(this.getActionModel(), target, form);
    }

    @Override
    protected void configureOkButton(AjaxButton okButton) {
        this.applyAreYouSure(okButton);
    }

    private void applyAreYouSure(AjaxButton button) {
        ActionModel actionModel = this.getActionModel();
        ObjectAction action = actionModel.getAction();
        if (action.getSemantics().isAreYouSure()) {
            ConfirmUiModel confirmUiModel = ConfirmUiModel.ofAreYouSure((TranslationService)this.getTranslationService(), (ConfirmUiModel.Placement)ConfirmUiModel.Placement.BOTTOM);
            Decorators.getConfirm().decorate((Component)button, confirmUiModel);
        }
    }

    @Override
    public void onUpdate(AjaxRequestTarget target, ScalarPanelAbstract scalarPanelUpdated) {
        _Debug.onCondition((boolean)XrayUi.isXrayEnabled(), () -> _Debug.log((String)"about to update Param Form ..", (Object[])new Object[0]));
        ActionModel actionModel = this.getActionModel();
        ParameterUiModel updatedParamModel = (ParameterUiModel)scalarPanelUpdated.getModel();
        int paramNumberUpdated = updatedParamModel.getParameterIndex();
        int skipCount = paramNumberUpdated + 1;
        actionModel.streamPendingParamUiModels().skip(skipCount).forEach(paramModel -> {
            int paramIndex = paramModel.getParameterIndex();
            ParameterNegotiationModel pendingArgs = paramModel.getParameterNegotiationModel();
            ObjectActionParameter actionParameter = paramModel.getMetaModel();
            ManagedObject paramDefaultValue = actionParameter.getDefault(pendingArgs);
            if (ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)paramDefaultValue)) {
                pendingArgs.clearParamValue(paramIndex);
            } else {
                pendingArgs.setParamValue(paramIndex, paramDefaultValue);
            }
            ScalarPanelAbstract paramPanel = (ScalarPanelAbstract)this.paramPanels.get(paramIndex);
            ScalarPanelAbstract.Repaint repaint = paramPanel.updateIfNecessary((ParameterUiModel)paramModel, Optional.of(target));
            switch (repaint) {
                case ENTIRE_FORM: {
                    target.add(new Component[]{this});
                    break;
                }
                case PARAM_ONLY: {
                    paramPanel.repaint(target);
                    break;
                }
                case NOTHING: {
                    break;
                }
                default: {
                    throw _Exceptions.unmatchedCase((Object)((Object)repaint));
                }
            }
        });
    }

    @Override
    protected _Either<ActionModel, ScalarPropertyModel> getMemberModel() {
        return _Either.left((Object)this.getActionModel());
    }
}

