/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actions;

import java.io.Serializable;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

public class ActionParametersPanel
extends PanelAbstract<ManagedObject, ActionModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_HEADER = "header";
    private static final String ID_ACTION_NAME = "actionName";
    private boolean showHeader = true;

    public ActionParametersPanel(String id, ActionModel actionModel) {
        super(id, actionModel);
    }

    ActionModel getActionModel() {
        return (ActionModel)super.getModel();
    }

    protected void onInitialize() {
        super.onInitialize();
        ActionModel actionModel = (ActionModel)this.getModel();
        if (!actionModel.hasParameters()) {
            throw new IllegalStateException("model has no parameters!");
        }
        WebMarkupContainer header = new WebMarkupContainer(ID_HEADER){
            private static final long serialVersionUID = 5410724436024228792L;

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(ActionParametersPanel.this.showHeader);
            }
        };
        this.addOrReplace(new Component[]{header});
        this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)this, ComponentType.PARAMETERS, (IModel<?>)actionModel);
        this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)header, ComponentType.ENTITY_ICON_AND_TITLE, (IModel)actionModel.getParentUiModel());
        Wkt.labelAdd((MarkupContainer)header, ID_ACTION_NAME, (IModel<String>)(IModel & Serializable)() -> this.getActionModel().getFriendlyName());
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }
}

