/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collection;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import java.util.Optional;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.core.metamodel.interactions.managed.nonscalar.DataTableModel;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModelParented;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.LinkAndLabelFactory;
import org.apache.isis.viewer.wicket.ui.components.collection.bulk.MultiselectToggleProvider;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorPanel;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorProvider;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.GenericToggleboxColumn;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;

public class CollectionPanel
extends PanelAbstract<DataTableModel, EntityCollectionModelParented>
implements CollectionSelectorProvider,
MultiselectToggleProvider {
    private static final long serialVersionUID = 1L;
    private static final String ID_FEEDBACK = "feedback";
    private Component collectionContents;
    private Label label;
    private CollectionSelectorPanel selectorDropdownPanel;
    private transient Optional<GenericToggleboxColumn> toggleboxColumn;

    public CollectionPanel(String id, EntityCollectionModelParented collectionModel) {
        super(id, collectionModel);
        OneToManyAssociation collMetaModel = ((EntityCollectionModelParented)this.getModel()).getMetaModel();
        Can associatedActions = (Can)collMetaModel.streamAssociatedActions().map(LinkAndLabelFactory.forCollection(collectionModel)).collect(Can.toCan());
        collectionModel.setLinkAndLabels((Iterable)associatedActions);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildGui();
    }

    private void buildGui() {
        this.collectionContents = this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)this, ComponentType.COLLECTION_CONTENTS, (IModel<?>)this.getModel());
        this.addOrReplace(new Component[]{new NotificationPanel(ID_FEEDBACK, this.collectionContents, (IFeedbackMessageFilter)new ComponentFeedbackMessageFilter(this.collectionContents))});
        this.setOutputMarkupId(true);
    }

    public Label createLabel(String id, String collectionName) {
        this.label = Wkt.label(id, collectionName);
        this.label.setOutputMarkupId(true);
        return this.label;
    }

    @Override
    public GenericToggleboxColumn getToggleboxColumn() {
        if (this.toggleboxColumn == null) {
            EntityCollectionModelParented collModel = (EntityCollectionModelParented)this.getModel();
            OneToManyAssociation collMetaModel = collModel.getMetaModel();
            this.toggleboxColumn = collMetaModel.hasAssociatedActionsWithChoicesFromThisCollection() ? Optional.of(new GenericToggleboxColumn(super.getCommonContext(), (IModel<DataTableModel>)collModel.delegate())) : Optional.empty();
        }
        return this.toggleboxColumn.orElse(null);
    }

    @Override
    public CollectionSelectorPanel getSelectorDropdownPanel() {
        return this.selectorDropdownPanel;
    }

    public void setSelectorDropdownPanel(CollectionSelectorPanel selectorDropdownPanel) {
        this.selectorDropdownPanel = selectorDropdownPanel;
    }
}

