/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collection.selector;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.isis.applib.layout.component.CollectionLayoutData;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.commons.collections.ImmutableEnumSet;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.facets.collections.collection.defaultview.DefaultViewFacet;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModelParented;
import org.apache.isis.viewer.wicket.model.util.ComponentHintKey;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.CollectionContentsAsAjaxTablePanelFactory;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.multiple.CollectionContentsMultipleViewsPanelFactory;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.springframework.lang.Nullable;

public class CollectionSelectorHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String UIHINT_EVENT_VIEW_KEY = "selectedItem";
    private final EntityCollectionModel collectionModel;
    private final List<ComponentFactory> componentFactories;
    private final ComponentHintKey componentHintKey;

    public CollectionSelectorHelper(EntityCollectionModel collectionModel, ComponentFactoryRegistry componentFactoryRegistry) {
        this(collectionModel, componentFactoryRegistry, ComponentHintKey.noop());
    }

    public CollectionSelectorHelper(EntityCollectionModel collectionModel, ComponentFactoryRegistry componentFactoryRegistry, ComponentHintKey componentHintKey) {
        this.collectionModel = collectionModel;
        this.componentFactories = this.locateComponentFactories(componentFactoryRegistry);
        this.componentHintKey = componentHintKey != null ? componentHintKey : ComponentHintKey.noop();
    }

    private List<ComponentFactory> locateComponentFactories(ComponentFactoryRegistry componentFactoryRegistry) {
        ArrayList ajaxFactoriesToEnd = _Lists.newArrayList();
        List<ComponentFactory> componentFactories = componentFactoryRegistry.streamComponentFactories((ImmutableEnumSet<ComponentType>)ImmutableEnumSet.of((Enum)ComponentType.COLLECTION_CONTENTS, (Enum)ComponentType.COLLECTION_CONTENTS_EXPORT), (IModel<?>)this.collectionModel).filter(componentFactory -> componentFactory.getClass() != CollectionContentsMultipleViewsPanelFactory.class).filter(componentFactory -> {
            if (componentFactory instanceof CollectionContentsAsAjaxTablePanelFactory) {
                ajaxFactoriesToEnd.add(componentFactory);
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        componentFactories.addAll(ajaxFactoriesToEnd);
        return componentFactories;
    }

    public String honourViewHintElseDefault(Component component) {
        String viewStr;
        UiHintContainer hintContainer = CollectionSelectorHelper.getUiHintContainer(component);
        if (hintContainer != null && (viewStr = hintContainer.getHint(component, UIHINT_EVENT_VIEW_KEY)) != null) {
            return viewStr;
        }
        String initialFactory = this.determineInitialFactory();
        if (hintContainer != null) {
            hintContainer.setHint(component, UIHINT_EVENT_VIEW_KEY, initialFactory);
        }
        return initialFactory;
    }

    private String determineInitialFactory() {
        String defaultView;
        Bookmark bookmark = this.collectionModel.parentedHintingBookmark().orElse(null);
        String sessionAttribute = this.componentHintKey.get(bookmark);
        if (sessionAttribute != null) {
            return sessionAttribute;
        }
        CollectionLayoutData layoutData = CollectionSelectorHelper.toParentedEntityCollectionModel(this.collectionModel).map(EntityCollectionModelParented::getLayoutData).orElse(null);
        if (layoutData != null && (defaultView = layoutData.getDefaultView()) != null) {
            return defaultView;
        }
        if (CollectionSelectorHelper.hasDefaultViewFacet(this.collectionModel)) {
            DefaultViewFacet defaultViewFacet = (DefaultViewFacet)this.collectionModel.getMetaModel().getFacet(DefaultViewFacet.class);
            for (ComponentFactory componentFactory : this.componentFactories) {
                String viewName;
                String componentName = componentFactory.getName();
                if (!componentName.equalsIgnoreCase(viewName = (String)defaultViewFacet.value())) continue;
                return componentName;
            }
        }
        return CollectionSelectorHelper.hasRenderEagerlyFacet(this.collectionModel) || this.collectionModel.getVariant().isStandalone() ? "table" : "hidden";
    }

    private static UiHintContainer getUiHintContainer(Component component) {
        return UiHintContainer.Util.hintContainerOf((Component)component, EntityCollectionModelParented.class);
    }

    private static boolean hasRenderEagerlyFacet(IModel<?> model) {
        return CollectionSelectorHelper.toParentedEntityCollectionModel(model).map(EntityCollectionModelParented::getMetaModel).map(CollectionSelectorHelper::isRenderEagerly).orElse(false);
    }

    private static boolean isRenderEagerly(OneToManyAssociation collectionMetaModel) {
        DefaultViewFacet defaultViewFacet = (DefaultViewFacet)collectionMetaModel.getFacet(DefaultViewFacet.class);
        return defaultViewFacet != null && Objects.equals(defaultViewFacet.value(), "table");
    }

    private static boolean hasDefaultViewFacet(IModel<?> model) {
        EntityCollectionModelParented entityCollectionModel = CollectionSelectorHelper.toParentedEntityCollectionModel(model).orElse(null);
        if (entityCollectionModel == null) {
            return false;
        }
        OneToManyAssociation collection = entityCollectionModel.getMetaModel();
        DefaultViewFacet defaultViewFacet = (DefaultViewFacet)collection.getFacet(DefaultViewFacet.class);
        return defaultViewFacet != null;
    }

    public ComponentFactory find(String selected) {
        ComponentFactory componentFactory = this.doFind(selected);
        if (componentFactory != null) {
            return componentFactory;
        }
        String fallback = this.collectionModel.getVariant().isParented() ? "hidden" : "table";
        componentFactory = this.doFind(fallback);
        if (componentFactory == null) {
            throw new IllegalStateException(String.format("Could not locate '%s' (as the fallback collection panel)", fallback));
        }
        return componentFactory;
    }

    private ComponentFactory doFind(String selected) {
        for (ComponentFactory componentFactory : this.componentFactories) {
            if (!selected.equals(componentFactory.getName())) continue;
            return componentFactory;
        }
        return null;
    }

    public int lookup(String view) {
        int i = 0;
        for (ComponentFactory componentFactory : this.componentFactories) {
            if (view.equals(componentFactory.getName())) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private static Optional<EntityCollectionModelParented> toParentedEntityCollectionModel(@Nullable IModel<?> model) {
        if (model instanceof EntityCollectionModelParented) {
            return Optional.of((EntityCollectionModelParented)model);
        }
        return Optional.empty();
    }

    public List<ComponentFactory> getComponentFactories() {
        return this.componentFactories;
    }
}

