/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.interactions.managed.nonscalar.DataTableModel;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.ui.components.collection.bulk.MultiselectToggleProvider;
import org.apache.isis.viewer.wicket.ui.components.collection.count.CollectionCountProvider;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.CollectionContentsSortableDataProvider;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.IsisAjaxDataTable;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.GenericColumn;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.GenericPropertyColumn;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.GenericTitleColumn;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.GenericToggleboxColumn;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class CollectionContentsAsAjaxTablePanel
extends PanelAbstract<DataTableModel, EntityCollectionModel>
implements CollectionCountProvider {
    private static final long serialVersionUID = 1L;
    private static final String ID_TABLE = "table";

    public CollectionContentsAsAjaxTablePanel(String id, EntityCollectionModel model) {
        super(id, model);
    }

    @Override
    public Integer getCount() {
        return ((EntityCollectionModel)this.getModel()).getDataTableModel().getElementCount();
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildGui();
    }

    protected void onModelChanged() {
    }

    private EntityCollectionModel entityCollectionModel() {
        return (EntityCollectionModel)this.getModel();
    }

    private void buildGui() {
        ArrayList columns = _Lists.newArrayList();
        MultiselectToggleProvider multiselectToggleProvider = this.getMultiselectToggleProvider();
        GenericToggleboxColumn toggleboxColumn = null;
        if (multiselectToggleProvider != null && (toggleboxColumn = multiselectToggleProvider.getToggleboxColumn()) != null) {
            columns.add(toggleboxColumn);
        }
        EntityCollectionModel collectionModel = this.entityCollectionModel();
        this.addTitleColumn(columns, collectionModel.getVariant(), this.getWicketViewerSettings().getMaxTitleLengthInParentedTables(), this.getWicketViewerSettings().getMaxTitleLengthInStandaloneTables());
        this.addPropertyColumnsIfRequired(columns);
        CollectionContentsSortableDataProvider dataProvider = new CollectionContentsSortableDataProvider((IModel<DataTableModel>)collectionModel);
        IsisAjaxDataTable dataTable = new IsisAjaxDataTable(ID_TABLE, columns, dataProvider, collectionModel.getPageSize(), toggleboxColumn);
        this.addOrReplace(new Component[]{dataTable});
    }

    private MultiselectToggleProvider getMultiselectToggleProvider() {
        for (CollectionContentsAsAjaxTablePanel component = this; component != null; component = component.getParent()) {
            if (!(component instanceof MultiselectToggleProvider)) continue;
            return (MultiselectToggleProvider)((Object)component);
        }
        return null;
    }

    private void addTitleColumn(List<GenericColumn> columns, EntityCollectionModel.Variant variant, int maxTitleParented, int maxTitleStandalone) {
        Bookmark contextBookmark = this.entityCollectionModel().getParentObject().getBookmark().orElse(null);
        int maxTitleLength = ((EntityCollectionModel)this.getModel()).getVariant().isParented() ? maxTitleParented : maxTitleStandalone;
        columns.add(new GenericTitleColumn(super.getCommonContext(), variant, contextBookmark, maxTitleLength));
    }

    private void addPropertyColumnsIfRequired(List<GenericColumn> columns) {
        EntityCollectionModel collectionModel = (EntityCollectionModel)this.getModel();
        ObjectSpecification elementTypeSpec = collectionModel.getElementType();
        if (elementTypeSpec == null) {
            return;
        }
        ManagedObject parentObject = collectionModel.getParentObject();
        Identifier memberIdentifier = collectionModel.getIdentifier();
        elementTypeSpec.streamPropertiesForColumnRendering(memberIdentifier, parentObject).map(this::createObjectAdapterPropertyColumn).forEach(columns::add);
    }

    private GenericPropertyColumn createObjectAdapterPropertyColumn(OneToOneAssociation property) {
        EntityCollectionModel collectionModel = (EntityCollectionModel)this.getModel();
        boolean escaped = true;
        String parentTypeName = property.getDeclaringType().getLogicalTypeName();
        IsisAppCommonContext commonContext = super.getCommonContext();
        return new GenericPropertyColumn(commonContext, collectionModel.getVariant(), (IModel<String>)Model.of((Serializable)((Object)property.getCanonicalFriendlyName())), property.getId(), property.getId(), true, parentTypeName, property.getCanonicalDescription());
    }
}

