/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable;

import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.CollectionContentsSortableDataProvider;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.IsisAjaxDataTable;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.IsisAjaxFallbackOrderByBorder;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.IsisAjaxHeadersToolbarAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.markup.html.WebMarkupContainer;

public class IsisAjaxHeadersToolbar
extends IsisAjaxHeadersToolbarAbstract<String> {
    private static final long serialVersionUID = 1L;
    private final CollectionContentsSortableDataProvider stateLocator;
    private IsisAjaxDataTable table;

    public IsisAjaxHeadersToolbar(IsisAjaxDataTable table, CollectionContentsSortableDataProvider stateLocator) {
        super(table, (ISortStateLocator)_Casts.uncheckedCast((Object)((Object)stateLocator)));
        this.table = table;
        table.setOutputMarkupId(true);
        this.stateLocator = stateLocator;
    }

    protected void onInitialize() {
        super.onInitialize();
    }

    @Override
    protected WebMarkupContainer newSortableHeader(String borderId, String property, ISortStateLocator<String> locator) {
        return new IsisAjaxFallbackOrderByBorder<String>(borderId, this.table, property, locator);
    }

    void honourSortOrderHints() {
        UiHintContainer uiHintContainer = this.getUiHintContainer();
        if (uiHintContainer == null) {
            return;
        }
        for (SortOrder sortOrder : SortOrder.values()) {
            String property = uiHintContainer.getHint((Component)this.table, sortOrder.name());
            if (property == null) continue;
            this.stateLocator.getSortState().setPropertySortOrder((Object)property, sortOrder);
        }
    }

    private UiHintContainer getUiHintContainer() {
        return UiHintContainer.Util.hintContainerOf((Component)this, EntityModel.class);
    }
}

