/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable;

import java.util.Locale;
import org.apache.isis.commons.internal.base._Timing;
import org.apache.isis.core.interaction.session.IsisInteraction;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.wicket.model.util.CommonContextUtils;

class PrototypingMessageProvider {
    private static IsisAppCommonContext commonContext = null;

    PrototypingMessageProvider() {
    }

    public static String getTookTimingMessageModel() {
        return PrototypingMessageProvider.isPrototyping() ? PrototypingMessageProvider.getTookTimingMessage() : "";
    }

    private static IsisAppCommonContext commonContext() {
        commonContext = CommonContextUtils.computeIfAbsent((IsisAppCommonContext)commonContext);
        return commonContext;
    }

    private static boolean isPrototyping() {
        return PrototypingMessageProvider.commonContext().getSystemEnvironment().isPrototyping();
    }

    private static String getTookTimingMessage() {
        StringBuilder tookTimingMessage = new StringBuilder();
        PrototypingMessageProvider.commonContext().getInteractionLayerTracker().currentInteraction().map(IsisInteraction.class::cast).ifPresent(interaction -> {
            _Timing.StopWatch stopWatch = _Timing.atSystemNanos((long)interaction.getStartedAtSystemNanos());
            tookTimingMessage.append(String.format(Locale.US, "... took %.2f seconds", stopWatch.getSeconds()));
        });
        return tookTimingMessage.toString();
    }
}

