/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns;

import java.util.Optional;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.commons.ScalarRepresentation;
import org.apache.isis.core.metamodel.interactions.managed.nonscalar.DataRow;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.GenericColumnAbstract;
import org.apache.isis.viewer.wicket.ui.util.Tooltips;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;

public final class GenericPropertyColumn
extends GenericColumnAbstract {
    private static final long serialVersionUID = 1L;
    private final EntityCollectionModel.Variant collectionVariant;
    private final String propertyId;
    private final boolean escaped;
    private final String parentTypeName;
    private final String describedAs;

    public GenericPropertyColumn(IsisAppCommonContext commonContext, EntityCollectionModel.Variant collectionVariant, IModel<String> columnNameModel, String sortProperty, String propertyId, boolean escaped, String parentTypeName, Optional<String> describedAs) {
        super(commonContext, columnNameModel, sortProperty);
        this.collectionVariant = collectionVariant;
        this.propertyId = propertyId;
        this.escaped = escaped;
        this.parentTypeName = parentTypeName;
        this.describedAs = describedAs.orElse(null);
    }

    public Component getHeader(String componentId) {
        Label label = new Label(componentId, this.getDisplayModel());
        label.setEscapeModelStrings(this.escaped);
        if (this.describedAs != null) {
            Tooltips.addTooltip((Component)label, this.describedAs);
        }
        return label;
    }

    public String getCssClass() {
        String cssClass = super.getCssClass();
        return (String)(_Strings.isNotEmpty((CharSequence)cssClass) ? cssClass + " " : "") + Wkt.cssNormalize("isis-" + this.parentTypeName + "-" + this.propertyId);
    }

    public void populateItem(Item<ICellPopulator<DataRow>> cellItem, String componentId, IModel<DataRow> rowModel) {
        cellItem.add(new Component[]{this.createComponent(componentId, rowModel)});
    }

    private Component createComponent(String id, IModel<DataRow> rowModel) {
        ManagedObject domainObject = ((DataRow)rowModel.getObject()).getRowElement();
        OneToOneAssociation property = domainObject.getSpecification().getPropertyElseFail(this.propertyId);
        EntityModel entityModel = EntityModel.ofAdapter((IsisAppCommonContext)super.getCommonContext(), (ManagedObject)domainObject);
        ScalarModel scalarModel = entityModel.getPropertyModel(property, ScalarRepresentation.VIEWING, this.collectionVariant.getColumnRenderingHint());
        ComponentFactory componentFactory = this.findComponentFactory(ComponentType.SCALAR_NAME_AND_VALUE, (IModel<?>)scalarModel);
        return componentFactory.createComponent(id, (IModel<?>)scalarModel);
    }
}

